/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.option.DescriptorPanel;
import uk.co.mmscomputing.device.sane.option.IntRange;

public class IntRangePanel
extends DescriptorPanel {
    JSlider[] sliders = null;
    JTextField[] tfs = null;

    public IntRangePanel(IntRange intRange) {
        super(intRange);
        int n;
        int n2 = intRange.size >> 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n2, 1));
        this.tfs = new JTextField[n2];
        this.sliders = new JSlider[n2];
        for (n = 0; n < n2; ++n) {
            jPanel.add(this.createRangePanel(n));
        }
        n = intRange.max - intRange.min;
        this.sliders[n2 - 1].setMajorTickSpacing(n / 10);
        this.sliders[n2 - 1].setPaintLabels(true);
        this.addValuePanel(new JScrollPane(jPanel));
    }

    private JPanel createRangePanel(int n) {
        IntRange intRange = (IntRange)this.od;
        JSlider jSlider = new JSlider(0, intRange.min, intRange.max, intRange.min);
        jSlider.addChangeListener(this);
        this.checkCapabilities(jSlider);
        JTextField jTextField = new JTextField(10);
        jTextField.addActionListener(this);
        jTextField.setHorizontalAlignment(4);
        this.checkCapabilities(jTextField);
        jTextField.setText(intRange.getStringValue(n));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSlider, "Center");
        jPanel.add((Component)jTextField, "East");
        jSlider.setValue(intRange.getWordValue(n));
        this.sliders[n] = jSlider;
        this.tfs[n] = jTextField;
        return jPanel;
    }

    void signalNewValue() {
        System.out.println("9\b" + this.getClass().getName() + ".signalNewValue:\n\t");
        this.sliders[0].setValue(this.od.getWordValue(0));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        for (int i = 0; i < this.sliders.length; ++i) {
            if (this.sliders[i] != jSlider) continue;
            JTextField jTextField = this.tfs[i];
            jTextField.setText("" + jSlider.getValue());
            if (jSlider.getValueIsAdjusting()) continue;
            try {
                this.od.setWordValue(i, jSlider.getValue());
                jTextField.setText(this.od.getStringValue(i));
                continue;
            }
            catch (SaneIOException saneIOException) {
                saneIOException.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        for (int i = 0; i < this.tfs.length; ++i) {
            if (this.tfs[i] != jTextField) continue;
            try {
                this.od.setStringValue(i, jTextField.getText());
                this.sliders[i].setValue(this.od.getWordValue(i));
                continue;
            }
            catch (SaneIOException saneIOException) {
                saneIOException.printStackTrace();
            }
        }
    }
}

