/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import uk.co.mmscomputing.imageio.bmp.BMPMetadata;

public class TwainBufferedImage
extends BufferedImage {
    private static String[] propertyNames = new String[]{"iiometadata"};
    private BMPMetadata md = new BMPMetadata();

    public TwainBufferedImage(int n, int n2, int n3) {
        super(n, n2, n3);
        int n4 = 24;
        this.md.setWidth(n);
        this.md.setHeight(n2);
        this.md.setBitsPerPixel(n4);
        this.md.setCompression(0);
        this.md.setImageSize((n * n4 + 31 >> 5 << 2) * n2);
        this.md.setXPixelsPerMeter(2953);
        this.md.setYPixelsPerMeter(2953);
    }

    public TwainBufferedImage(int n, int n2, int n3, IndexColorModel indexColorModel) {
        super(n, n2, n3, indexColorModel);
        this.md.setWidth(n);
        this.md.setHeight(n2);
        int n4 = 8;
        switch (indexColorModel.getMapSize()) {
            case 2: {
                n4 = 1;
                break;
            }
            case 16: {
                n4 = 4;
            }
        }
        this.md.setBitsPerPixel(n4);
        this.md.setCompression(0);
        this.md.setXPixelsPerMeter(2953);
        this.md.setYPixelsPerMeter(2953);
        this.md.setIndexColorModel(indexColorModel);
        this.md.setImageSize((n * n4 + 31 >> 5 << 2) * n2);
    }

    public byte[] getBuffer() {
        WritableRaster writableRaster = this.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        return dataBufferByte.getData();
    }

    public void setXPixelsPerMeter(int n) {
        this.md.setXPixelsPerMeter(n);
    }

    public void setYPixelsPerMeter(int n) {
        this.md.setYPixelsPerMeter(n);
    }

    public void setPixelsPerMeter(int n, int n2) {
        this.setXPixelsPerMeter(n);
        this.setYPixelsPerMeter(n2);
    }

    public Object getProperty(String string) {
        if (string.equals("iiometadata")) {
            return this.md;
        }
        if (string.equals("resolution")) {
            return "" + this.md.getXDotsPerInch();
        }
        return Image.UndefinedProperty;
    }

    public String[] getPropertyNames() {
        return propertyNames;
    }
}

