/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainResultException;

public class TwainFailureException
extends TwainResultException {
    private static final int TWCC_BADCAP = 6;
    private static final int TWCC_CAPUNSUPPORTED = 13;
    private int cc;

    public TwainFailureException(int n) {
        super(TwainFailureException.createMessage("Failed during call to twain source.", n), 1);
    }

    public TwainFailureException(String string, int n) {
        super(TwainFailureException.createMessage(string, n), 1);
    }

    public int getConditionCode() {
        return this.cc;
    }

    private static String createMessage(String string, int n) {
        try {
            return string + "\n\tcc=" + TwainConstants.info[n];
        }
        catch (Exception exception) {
            return string + "\n\tcc=0x" + Integer.toHexString(n);
        }
    }

    public static TwainFailureException create(int n) {
        switch (n) {
            case 6: {
                return new BadCap();
            }
            case 13: {
                return new CapUnsupported();
            }
        }
        return new TwainFailureException(n);
    }

    public static class CapUnsupported
    extends TwainFailureException {
        public CapUnsupported() {
            super(13);
        }
    }

    public static class BadCap
    extends TwainFailureException {
        public BadCap() {
            super(6);
        }
    }
}

