/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.util.Vector;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainFailureException;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainIdentity;
import uk.co.mmscomputing.device.twain.TwainResultException;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainSourceManager
implements TwainConstants {
    private TwainSource source;

    TwainSourceManager(long l) {
        this.source = new TwainSource(this, l, false);
        this.source.getDefault();
    }

    int getConditionCode() throws TwainIOException {
        byte[] byArray = new byte[4];
        int n = jtwain.callSourceManager(1, 8, 1, byArray);
        if (n != 0) {
            throw new TwainResultException("Cannot retrieve twain source manager's status.", n);
        }
        return jtwain.getINT16(byArray, 0);
    }

    public void call(int n, int n2, int n3, byte[] byArray) throws TwainIOException {
        int n4 = jtwain.callSourceManager(n, n2, n3, byArray);
        switch (n4) {
            case 0: {
                return;
            }
            case 1: {
                throw new TwainFailureException(this.getConditionCode());
            }
            case 2: {
                throw new TwainResultException.CheckStatus();
            }
            case 3: {
                throw new TwainResultException.Cancel();
            }
            case 4: {
                return;
            }
            case 5: {
                throw new TwainResultException.NotDSEvent();
            }
            case 6: {
                throw new TwainResultException.TransferDone();
            }
            case 7: {
                throw new TwainResultException.EndOfList();
            }
        }
        throw new TwainResultException("Failed to call source manager.", n4);
    }

    TwainSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TwainSource selectSource() throws TwainIOException {
        this.source.checkState(3);
        this.source.setBusy(true);
        try {
            this.source.userSelect();
            TwainSource twainSource = this.source;
            return twainSource;
        }
        catch (TwainResultException.Cancel cancel) {
            TwainSource twainSource = this.source;
            return twainSource;
        }
        finally {
            this.source.setBusy(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getIdentities(Vector vector) throws ScannerIOException {
        this.source.checkState(3);
        this.source.setBusy(true);
        try {
            TwainIdentity twainIdentity = new TwainIdentity(this);
            twainIdentity.getFirst();
            vector.add(twainIdentity);
            while (true) {
                twainIdentity = new TwainIdentity(this);
                twainIdentity.getNext();
                vector.add(twainIdentity);
            }
        }
        catch (TwainResultException.EndOfList endOfList) {
            this.source.setBusy(false);
        }
        catch (TwainIOException twainIOException) {
            try {
                System.out.println(this.getClass().getName() + ".getIdentities:\n\t" + twainIOException);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.source.setBusy(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TwainSource selectSource(String string) throws ScannerIOException {
        this.source.checkState(3);
        this.source.setBusy(true);
        try {
            this.source.select(string);
            TwainSource twainSource = this.source;
            return twainSource;
        }
        finally {
            this.source.setBusy(false);
        }
    }

    TwainSource openSource() throws TwainIOException {
        this.source.checkState(3);
        this.source.setBusy(true);
        try {
            this.source.open();
            if (!this.source.isDeviceOnline()) {
                this.source.close();
                throw new TwainIOException("Selected twain source is not online.");
            }
            this.source.setState(4);
            return this.source;
        }
        catch (TwainResultException.Cancel cancel) {
            this.source.setBusy(false);
            return this.source;
        }
        catch (TwainIOException twainIOException) {
            this.source.setBusy(false);
            throw twainIOException;
        }
    }
}

