/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain.pdfapplet;

import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class TwainPdfAppletExample
extends Applet
implements ActionListener,
ScannerListener {
    static TwainPdfAppletExample app;
    Scanner scanner;
    Button acquireButton;
    Button selectButton;
    File dir;

    public void init() {
        this.setLayout(new GridLayout(0, 2));
        this.selectButton = new Button("select");
        this.add(this.selectButton);
        this.selectButton.addActionListener(this);
        this.acquireButton = new Button("acquire");
        this.add(this.acquireButton);
        this.acquireButton.addActionListener(this);
        this.scanner = Scanner.getDevice();
        this.scanner.addListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            try {
                if (actionEvent.getSource() == this.acquireButton) {
                    try {
                        File file = new File(System.getProperty("user.home"));
                        this.dir = new File(file, "My Documents");
                        if (!this.dir.exists()) {
                            this.dir = file;
                        }
                        File file2 = new File(this.dir, "testIO.pdf");
                        file2.delete();
                        System.out.println(file2.getCanonicalPath());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.scanner.acquire();
                    break block7;
                }
                if (actionEvent.getSource() == this.selectButton) {
                    this.scanner.select();
                }
            }
            catch (ScannerIOException scannerIOException) {
                scannerIOException.printStackTrace();
            }
        }
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        try {
            if (type.equals(ScannerIOMetadata.ACQUIRED)) {
                BufferedImage bufferedImage = scannerIOMetadata.getImage();
                System.out.println("Have an image now!");
                File file = new File(this.dir, "testIO.pdf");
                file.delete();
                ImageIO.write((RenderedImage)bufferedImage, "pdf", file);
            } else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
                System.out.println(scannerIOMetadata.getStateStr());
                if (scannerIOMetadata.isFinished()) {
                    // empty if block
                }
            } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
                scannerIOMetadata.getException().printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void main(String string, String[] stringArray) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(this);
        jFrame.setSize(500, 200);
        jFrame.setLocationRelativeTo(null);
        this.init();
        jFrame.setVisible(true);
        this.start();
    }

    public static void main(String[] stringArray) {
        try {
            TwainPdfAppletExample twainPdfAppletExample = new TwainPdfAppletExample();
            twainPdfAppletExample.main(TwainPdfAppletExample.class.getName(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

