/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain.tiffapplet;

import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class TwainTiffAppletExample
extends Applet
implements ActionListener,
ScannerListener {
    Scanner scanner;
    Button acquireButton;
    Button selectButton;
    ImageWriter writer;
    boolean writeImage = false;

    public void init() {
        this.setLayout(new GridLayout(0, 2));
        this.selectButton = new Button("select");
        this.add(this.selectButton);
        this.selectButton.addActionListener(this);
        this.acquireButton = new Button("acquire");
        this.add(this.acquireButton);
        this.acquireButton.addActionListener(this);
        this.scanner = Scanner.getDevice();
        this.scanner.addListener(this);
        this.writer = ImageIO.getImageWritersByFormatName("tif").next();
        System.out.println(this.writer.getClass().getName());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            try {
                if (actionEvent.getSource() == this.acquireButton) {
                    try {
                        File file = new File(System.getProperty("user.home"));
                        File file2 = new File(file, "My Documents");
                        if (!file2.exists()) {
                            file2 = file;
                        }
                        File file3 = new File(file2, "test.tif");
                        file3.delete();
                        this.showStatus(file3.getCanonicalPath());
                        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file3);
                        this.writer.setOutput(imageOutputStream);
                        this.writer.prepareWriteSequence(null);
                        this.writeImage = true;
                    }
                    catch (Exception exception) {
                        this.writeImage = false;
                        exception.printStackTrace();
                    }
                    this.scanner.acquire();
                    break block7;
                }
                if (actionEvent.getSource() == this.selectButton) {
                    this.scanner.select();
                }
            }
            catch (ScannerIOException scannerIOException) {
                scannerIOException.printStackTrace();
            }
        }
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        try {
            if (type.equals(ScannerIOMetadata.ACQUIRED)) {
                BufferedImage bufferedImage = scannerIOMetadata.getImage();
                System.out.println("Have an image now!");
                if (this.writeImage) {
                    this.writer.writeToSequence(new IIOImage(bufferedImage, null, null), null);
                }
            } else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
                System.out.println(scannerIOMetadata.getStateStr());
                if (scannerIOMetadata.isFinished()) {
                    this.writer.endWriteSequence();
                    ((ImageOutputStream)this.writer.getOutput()).close();
                }
            } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
                scannerIOMetadata.getException().printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

