/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.dsp.phone;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FSKInputStream
extends FilterInputStream {
    public static final int QUIET = 0;
    public static final int MARK = 1;
    public static final int SPACE = 2;
    private static final int max = 7;
    private static final double[][] retab = new double[7][7];
    private static final double[][] imtab = new double[7][7];
    protected byte[] pcm = new byte[2];
    protected double[] au = new double[7];
    private byte[] bytes = new byte[256];
    private int len;
    private int index;

    public FSKInputStream(InputStream inputStream) {
        super(inputStream);
    }

    protected boolean readSample() throws IOException {
        if (this.in.read(this.pcm) != 2) {
            return false;
        }
        for (int i = this.au.length - 1; i > 0; --i) {
            this.au[i] = this.au[i - 1];
        }
        this.au[0] = this.pcm[0] & 0xFF | this.pcm[1] << 8;
        return true;
    }

    private int getFrequency() {
        double d = 0.0;
        int n = 0;
        int n2 = 3;
        for (int i = 0; i <= n2; ++i) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < this.au.length; ++j) {
                d2 += retab[i][j] * this.au[j];
                d3 -= imtab[i][j] * this.au[j];
            }
            double d4 = (d2 = Math.abs(d2) < 1.0E-5 ? 0.0 : d2) * d2 + (d3 = Math.abs(d3) < 0.001 ? 0.0 : d3) * d3;
            if (!(d4 > d)) continue;
            d = d4;
            n = i;
        }
        if (d < 1000000.0) {
            return 0;
        }
        if (n == 3) {
            return 0;
        }
        return n;
    }

    public int readQuiet() throws IOException {
        int n = 0;
        while (true) {
            if (!this.readSample()) {
                if (n != 0) break;
                return -1;
            }
            if (this.getFrequency() != 0) break;
            ++n;
        }
        return n;
    }

    public int readBits(int n) throws IOException {
        int n2;
        block5: {
            int n3;
            n2 = 0;
            while (true) {
                if (!this.readSample()) {
                    if (n2 == 0) {
                        return -1;
                    }
                    break block5;
                }
                n3 = this.getFrequency();
                if (n3 == n) {
                    ++n2;
                    continue;
                }
                if (n2 != 0) break;
                ++n2;
            }
            if (n3 == 0) {
                // empty if block
            }
        }
        return (int)((double)(++n2) * 0.15 + 0.5);
    }

    public boolean readMarkSignal(int n) throws IOException {
        int n2;
        do {
            int n3;
            if ((n3 = this.readQuiet()) == -1) {
                return false;
            }
            n2 = this.readBits(1);
            if (n2 != -1) continue;
            return false;
        } while (n2 < n);
        return true;
    }

    protected int readBuffer() throws IOException {
        int n = 0;
        while (n < this.bytes.length) {
            int n2;
            int n3;
            block7: {
                n3 = this.readBits(2);
                if (n3 == -1) {
                    return n == 0 ? -1 : n;
                }
                if (n3 == 0) {
                    throw new IOException(this.getClass().getName() + ".readBuffer:\n\tCorrupt message.Not enough bits per byte. Missing START bit.");
                }
                int n4 = 0;
                n2 = --n3;
                do {
                    if ((n3 = this.readBits(1)) == -1) {
                        throw new IOException(this.getClass().getName() + ".readBuffer:\n\tCorrupt message.Not enough bits per byte. Missing MARK bits.");
                    }
                    if (n2 + n3 >= 8) {
                        if (n2 + n3 != 9) {
                            n3 = 8 - n2;
                            this.bytes[n++] = (byte)(n4 |= ~(-1 << n3) << n2);
                            return n;
                        }
                        break block7;
                    }
                    n4 |= ~(-1 << n3) << n2;
                    n2 += n3;
                    n3 = this.readBits(2);
                    if (n3 != -1) continue;
                    throw new IOException(this.getClass().getName() + ".readBuffer:\n\tCorrupt message.Not enough bits per byte. Missing SPACE bits.");
                } while ((n2 += n3) <= 8);
                throw new IOException(this.getClass().getName() + ".readBuffer:\n\tCorrupt message.Too many bits per byte. Missing STOP bit.");
            }
            this.bytes[n++] = (byte)(n4 |= ~(-1 << --n3) << n2);
        }
        return n;
    }

    public int available() throws IOException {
        return this.len - this.index;
    }

    public int read() throws IOException {
        while (this.index >= this.len) {
            this.len = this.readBuffer();
            if (this.len == -1) {
                this.index = -1;
                return -1;
            }
            this.index = 0;
        }
        return this.bytes[this.index++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".read(byte[] buf, int off, int len): buf is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".read(byte[] buf, int off, int len): index off [" + n + "] or len [" + n2 + "] out of bounds [" + byArray.length + "].");
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                return i == 0 ? -1 : i;
            }
            byArray[n++] = (byte)n3;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "uk/co/mmscomputing/dsp/phone/fsk.raw";
            FSKInputStream fSKInputStream = new FSKInputStream(new FileInputStream(string));
            int n = 0;
            if (fSKInputStream.readMarkSignal(55)) {
                int n2;
                while ((n2 = fSKInputStream.read()) != -1) {
                    System.out.println(" " + n + " , " + Integer.toHexString(n2) + " , " + Integer.toBinaryString(n2) + " , " + (char)n2);
                    ++n;
                }
            }
            fSKInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                double d = Math.PI * 2 * (double)i * (double)j / 7.0;
                FSKInputStream.retab[i][j] = 0.14285714285714285 * Math.cos(d);
                FSKInputStream.imtab[i][j] = 0.14285714285714285 * Math.sin(d);
            }
        }
    }
}

