/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.dsp.phone;

import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FSKOutputStream
extends FilterOutputStream {
    private static final int[] mark2space = new int[]{0, 1, 66, 59, 52, 45, 38, 31, 24, 17, 10, 37, 76, 69, 62, 55, 48, 41, 34, 27, 20, 13, 6, 22, 72, 65, 58, 51, 44, 37, 30, 23, 24, 9, 2, 45, 68, 61, 54, 47, 40, 41, 26, 19, 12, 5, 78, 71, 64, 57, 50, 77, 36, 29, 22, 15, 8, 1, 74, 67, 60, 53, 46, 62, 32, 25, 18, 11, 4, 77, 70, 63, 64, 49, 42, 5, 28, 21, 14, 7};
    private static final int[] space2mark = new int[]{0, 57, 34, 11, 68, 45, 22, 79, 56, 33, 10, 67, 44, 21, 78, 55, 32, 9, 66, 43, 20, 77, 54, 31, 8, 65, 42, 19, 76, 53, 30, 7, 64, 41, 18, 45, 52, 29, 6, 63, 40, 17, 74, 51, 28, 5, 62, 39, 16, 73, 50, 27, 4, 61, 38, 15, 72, 49, 26, 3, 60, 37, 14, 71, 48, 25, 2, 59, 36, 13, 70, 47, 24, 1, 58, 5, 12, 69, 46, 23};
    private static int[][] amps = new int[2][80];
    private int counter = 1;
    private int phase = 0;
    private int lastsymbol = 1;
    private byte[] pcm = new byte[2];

    public FSKOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    protected void writeSample(int n) throws IOException {
        this.pcm[0] = (byte)n;
        this.pcm[1] = (byte)(n >> 8);
        this.out.write(this.pcm);
    }

    public void writeDelay(int n) throws IOException {
        int n2 = n << 3;
        for (int i = 0; i < n2; ++i) {
            this.writeSample(0);
        }
    }

    public void writeBit(int n) throws IOException {
        int n2;
        int[] nArray = amps[n & 1];
        if (n != this.lastsymbol) {
            this.phase = this.lastsymbol == 0 ? space2mark[this.phase] : mark2space[this.phase];
        }
        ++this.counter;
        if (this.counter == 3) {
            n2 = 6;
            this.counter = 0;
        } else {
            n2 = 7;
        }
        for (int i = 0; i < n2; ++i) {
            this.writeSample(nArray[this.phase]);
            this.phase = (this.phase + 1) % nArray.length;
        }
        this.lastsymbol = n;
    }

    public void writeBits(int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeBit(n & 1);
            n >>= 1;
        }
    }

    public void write(int n) throws IOException {
        this.writeBit(0);
        this.writeBits(n, 8);
        this.writeBit(1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void writeMarkSignal(int n) throws IOException {
        this.writeBits(-1, n);
    }

    public static void main(String[] stringArray) {
        try {
            String string = "uk/co/mmscomputing/dsp/phone/fsk.raw";
            FSKOutputStream fSKOutputStream = new FSKOutputStream(new FileOutputStream(string));
            fSKOutputStream.writeMarkSignal(80);
            fSKOutputStream.write("Hello world!\n".getBytes());
            fSKOutputStream.write("ABCDEFGHIJKLMNOPQRSTUVWXYZ.".getBytes());
            fSKOutputStream.writeBits(-1, 10);
            fSKOutputStream.flush();
            fSKOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        for (int i = 0; i < 80; ++i) {
            FSKOutputStream.amps[0][i] = (int)(8192.0 * Math.sin(Math.PI * 2 * (double)i * 2100.0 / 8000.0 - 0.001));
            FSKOutputStream.amps[1][i] = (int)(8192.0 * Math.sin(Math.PI * 2 * (double)i * 1300.0 / 8000.0 - 0.001));
        }
    }
}

