/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.dsp.phone;

public class FSKTestUnit {
    private static final int EOF = -1;
    private static final int QUIET = 0;
    private static final int MARK = 1;
    private static final int SPACE = 2;
    private static final int[] markAmps = new int[]{-8, 6784, 7296, 624, -6528, -7552, -1248, 6272, 7808, 1888, -5760, -7808, -2496, 5248, 8064, 3136, -4736, -8064, -3648, 4224, 8064, 4224, -3648, -8064, -4736, 3136, 8064, 5248, -2496, -7808, -5760, 1888, 7808, 6272, -1248, -7552, -6528, 624, 7296, 6784, 8, -6784, -7296, -624, 6528, 7552, 1248, -6272, -7808, -1888, 5760, 7808, 2496, -5248, -8064, -3136, 4736, 8064, 3648, -4224, -8064, -4224, 3648, 8064, 4736, -3136, -8064, -5248, 2496, 7808, 5760, -1888, -7808, -6272, 1248, 7552, 6528, -624, -7296, -6784};
    private static final int[] spaceAmps = new int[]{-8, 8064, -1248, -7808, 2496, 7552, -3648, -6784, 4736, 6272, -5760, -5248, 6528, 4224, -7296, -3136, 7808, 1888, -8064, -624, 8064, -624, -8064, 1888, 7808, -3136, -7296, 4224, 6528, -5248, -5760, 6272, 4736, -6784, -3648, 7552, 2496, -7808, -1248, 8064, 8, -8064, 1248, 7808, -2496, -7552, 3648, 6784, -4736, -6272, 5760, 5248, -6528, -4224, 7296, 3136, -7808, -1888, 8064, 624, -8064, 624, 8064, -1888, -7808, 3136, 7296, -4224, -6528, 5248, 5760, -6272, -4736, 6784, 3648, -7552, -2496, 7808, 1248, -8064};
    private static final int[] mark2space = new int[]{0, 1, 66, 59, 52, 45, 38, 31, 24, 17, 10, 37, 76, 69, 62, 55, 48, 41, 34, 27, 20, 13, 6, 22, 72, 65, 58, 51, 44, 37, 30, 23, 24, 9, 2, 45, 68, 61, 54, 47, 40, 41, 26, 19, 12, 5, 78, 71, 64, 57, 50, 77, 36, 29, 22, 15, 8, 1, 74, 67, 60, 53, 46, 62, 32, 25, 18, 11, 4, 77, 70, 63, 64, 49, 42, 5, 28, 21, 14, 7};
    private static final int[] space2mark = new int[]{0, 57, 34, 11, 68, 45, 22, 79, 56, 33, 10, 67, 44, 21, 78, 55, 32, 9, 66, 43, 20, 77, 54, 31, 8, 65, 42, 19, 76, 53, 30, 7, 64, 41, 18, 45, 52, 29, 6, 63, 40, 17, 74, 51, 28, 5, 62, 39, 16, 73, 50, 27, 4, 61, 38, 15, 72, 49, 26, 3, 60, 37, 14, 71, 48, 25, 2, 59, 36, 13, 70, 47, 24, 1, 58, 5, 12, 69, 46, 23};
    protected static final int max = 7;
    private static final double[][] retab = new double[7][7];
    private static final double[][] imtab = new double[7][7];
    protected static double[] au = new double[7];
    protected static double[] re = new double[7];
    protected static double[] im = new double[7];

    private static int analyse() {
        double d;
        double d2;
        int n;
        double d3 = 0.0;
        int n2 = 0;
        for (n = 0; n < 7; ++n) {
            d2 = 0.0;
            d = 0.0;
            for (int i = 0; i < 7; ++i) {
                d2 += retab[n][i] * au[i];
                d -= imtab[n][i] * au[i];
            }
            FSKTestUnit.re[n] = d2;
            FSKTestUnit.im[n] = d;
        }
        for (n = 0; n < 4; ++n) {
            d2 = Math.abs(re[n]) < 1.0E-5 ? 0.0 : re[n];
            double d4 = d2 * d2 + (d = Math.abs(im[n]) < 0.001 ? 0.0 : im[n]) * d;
            if (!(d4 > d3)) continue;
            d3 = d4;
            n2 = n;
        }
        if (d3 < 1000000.0) {
            return 0;
        }
        if (n2 == 3) {
            return 0;
        }
        return n2;
    }

    static void testm2s(int n, int n2) {
        System.err.println("MARK -> SPACE " + n + " " + (n2 == 1 ? "MARK" : "SPACE"));
        for (int i = 0; i < markAmps.length; ++i) {
            int n3;
            int n4;
            for (n4 = n; n4 < au.length; ++n4) {
                FSKTestUnit.au[n4] = markAmps[(i - n4 + n - 1 + markAmps.length) % markAmps.length];
            }
            n4 = mark2space[i];
            for (n3 = 0; n3 < n; ++n3) {
                FSKTestUnit.au[n - 1 - n3] = spaceAmps[(n4 + n3) % spaceAmps.length];
            }
            n3 = FSKTestUnit.analyse();
            if (n3 == n2) continue;
            System.err.println("[" + i + "] = " + n3 + " " + markAmps[i] + " k=" + n4);
        }
    }

    static void tests2m(int n, int n2) {
        System.err.println("SPACE -> MARK " + n + " " + (n2 == 1 ? "MARK" : "SPACE"));
        for (int i = 0; i < spaceAmps.length; ++i) {
            int n3;
            int n4;
            for (n4 = n; n4 < au.length; ++n4) {
                FSKTestUnit.au[n4] = spaceAmps[(i - n4 + n - 1 + spaceAmps.length) % spaceAmps.length];
            }
            n4 = space2mark[i];
            for (n3 = 0; n3 < n; ++n3) {
                FSKTestUnit.au[n - 1 - n3] = markAmps[(n4 + n3) % markAmps.length];
            }
            n3 = FSKTestUnit.analyse();
            if (n3 == n2) continue;
            System.err.println("[" + i + "] = " + n3 + " " + markAmps[i] + " k=" + n4);
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            for (n2 = 0; n2 < markAmps.length; ++n2) {
                for (n = 0; n < au.length; ++n) {
                    FSKTestUnit.au[n] = markAmps[(n2 - n + markAmps.length) % markAmps.length];
                }
                n = FSKTestUnit.analyse();
                if (n == 1) continue;
                System.err.println("[" + n2 + "] = " + n + " " + markAmps[n2]);
            }
            for (n2 = 0; n2 < spaceAmps.length; ++n2) {
                for (n = 0; n < au.length; ++n) {
                    FSKTestUnit.au[n] = spaceAmps[(n2 - n + spaceAmps.length) % spaceAmps.length];
                }
                n = FSKTestUnit.analyse();
                if (n == 2) continue;
                System.err.println("[" + n2 + "] = " + n + " " + spaceAmps[n2]);
            }
            System.err.println("\n\nSPACE -> MARK");
            FSKTestUnit.tests2m(2, 2);
            FSKTestUnit.tests2m(3, 2);
            FSKTestUnit.tests2m(4, 1);
            FSKTestUnit.tests2m(5, 1);
            FSKTestUnit.tests2m(6, 1);
            System.err.println("\n\nMARK -> SPACE");
            FSKTestUnit.testm2s(2, 1);
            FSKTestUnit.testm2s(3, 1);
            FSKTestUnit.testm2s(4, 2);
            FSKTestUnit.testm2s(5, 2);
            FSKTestUnit.testm2s(6, 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                double d = Math.PI * 2 * (double)i * (double)j / 7.0;
                FSKTestUnit.retab[i][j] = 0.14285714285714285 * Math.cos(d);
                FSKTestUnit.imtab[i][j] = 0.14285714285714285 * Math.sin(d);
            }
        }
    }
}

