/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.image.operators;

import java.awt.image.BufferedImage;
import uk.co.mmscomputing.image.operators.Histogram;
import uk.co.mmscomputing.image.operators.Operator;

public class Binarization
extends Operator {
    private int rshift = 0;
    private int gshift = 0;
    private int bshift = 0;

    public Binarization() {
    }

    public Binarization(int n) {
        this.rshift += 64 - n * 128 / 100;
        this.gshift += 64 - n * 128 / 100;
        this.bshift += 64 - n * 128 / 100;
    }

    public BufferedImage filter(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 12: {
                return bufferedImage;
            }
            case 10: {
                return this.filterGray(bufferedImage);
            }
        }
        return this.filterRGB(bufferedImage);
    }

    public BufferedImage filterGray(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Histogram histogram = new Histogram(256);
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n3; ++i) {
                n = bufferedImage.getRGB(i, n2) & 0xFF;
                histogram.write(n);
            }
        }
        n2 = histogram.getThreshold();
        System.out.println("Threshold=[" + n2 + "]");
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 12);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                n = bufferedImage.getRGB(j, i) & 0xFF;
                if (n > n2) {
                    bufferedImage2.setRGB(j, i, -1);
                    continue;
                }
                bufferedImage2.setRGB(j, i, 0);
            }
        }
        return bufferedImage2;
    }

    public BufferedImage filterRGB(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        Histogram histogram = new Histogram(256);
        Histogram histogram2 = new Histogram(256);
        Histogram histogram3 = new Histogram(256);
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = bufferedImage.getRGB(n2, n3);
                histogram.write(n >> 16 & 0xFF);
                histogram2.write(n >> 8 & 0xFF);
                histogram3.write(n & 0xFF);
            }
        }
        n3 = histogram.getThreshold() + this.rshift;
        n2 = histogram2.getThreshold() + this.gshift;
        int n6 = histogram3.getThreshold() + this.bshift;
        System.out.println("Threshold[r,g,b]=[" + n3 + "," + n2 + "," + n6 + "]");
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, 12);
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                n = bufferedImage.getRGB(j, i);
                int n7 = n >> 16 & 0xFF;
                int n8 = n >> 8 & 0xFF;
                int n9 = n & 0xFF;
                if (n7 > n3 || n8 > n2 || n9 > n6) {
                    bufferedImage2.setRGB(j, i, -1);
                    continue;
                }
                bufferedImage2.setRGB(j, i, 0);
            }
        }
        return bufferedImage2;
    }
}

