/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.image.operators;

import java.awt.image.BufferedImage;
import java.util.Properties;
import uk.co.mmscomputing.image.operators.Binarization;
import uk.co.mmscomputing.image.operators.DekkerQuantiziser;
import uk.co.mmscomputing.image.operators.GrayScale;
import uk.co.mmscomputing.image.operators.HeckbertQuantiziser;
import uk.co.mmscomputing.image.operators.Operator;

public class ImageTypeConvertOp
extends Operator {
    private Properties params;

    public ImageTypeConvertOp(Properties properties) {
        this.params = properties;
        int n = Integer.parseInt(properties.getProperty("type"));
        int n2 = Integer.parseInt(properties.getProperty("bpp"));
        switch (n) {
            case 12: {
                if (n2 == 4 || n2 == 2 || n2 == 1) break;
                throw new IllegalArgumentException(this.getClass().getName() + "<init>:\n\tTYPE_BYTE_INDEXED supports only 1,2,4 bits per pixel. Not " + n2 + " bpp.");
            }
            case 13: {
                if (n2 == 8 || n2 == 4 || n2 == 2 || n2 == 1) break;
                throw new IllegalArgumentException(this.getClass().getName() + "<init>:\n\tTYPE_BYTE_INDEXED supports only 1,2,4,8 bits per pixel. Not " + n2 + " bpp.");
            }
            case 10: {
                if (n2 == 8) break;
                throw new IllegalArgumentException(this.getClass().getName() + "<init>:\n\tTYPE_BYTE_GRAY supports only 8 bits per pixel. Not " + n2 + " bpp.");
            }
            default: {
                throw new IllegalArgumentException(this.getClass().getName() + "<init>:\n\tUnsupported BufferedImageType");
            }
        }
    }

    public BufferedImage filter(BufferedImage bufferedImage) {
        int n = Integer.parseInt(this.params.getProperty("type"));
        switch (n) {
            case 12: {
                return this.filterByteBinary(bufferedImage);
            }
            case 13: {
                return this.filterByteIndexed(bufferedImage);
            }
            case 10: {
                return this.filterGrayScaled(bufferedImage);
            }
        }
        return bufferedImage;
    }

    private BufferedImage filterByteIndexed(BufferedImage bufferedImage) {
        int n = Integer.parseInt(this.params.getProperty("bpp"));
        switch (n) {
            case 1: {
                return new Binarization().filter(bufferedImage);
            }
            case 2: {
                return new HeckbertQuantiziser(2, true, false).filter(bufferedImage);
            }
            case 4: {
                return new HeckbertQuantiziser(4, true, false).filter(bufferedImage);
            }
            case 8: {
                return new DekkerQuantiziser().filter(bufferedImage);
            }
        }
        return bufferedImage;
    }

    private BufferedImage filterByteBinary(BufferedImage bufferedImage) {
        int n;
        int n2 = Integer.parseInt(this.params.getProperty("bpp"));
        try {
            n = Integer.parseInt(this.params.getProperty("threshold"));
        }
        catch (Exception exception) {
            n = 50;
        }
        switch (n2) {
            case 1: {
                return new Binarization(n).filter(bufferedImage);
            }
            case 2: {
                return new HeckbertQuantiziser(2, true, false).filter(bufferedImage);
            }
            case 4: {
                return new HeckbertQuantiziser(4, true, false).filter(bufferedImage);
            }
        }
        return bufferedImage;
    }

    private BufferedImage filterGrayScaled(BufferedImage bufferedImage) {
        int n = Integer.parseInt(this.params.getProperty("bpp"));
        switch (n) {
            case 8: {
                return new GrayScale().filter(bufferedImage);
            }
        }
        return bufferedImage;
    }
}

