/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.bmp;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.bmp.BMPImageReader;

public class BMPImageReaderSpi
extends ImageReaderSpi {
    static final String vendorName = "mm's computing";
    static final String version = "0.0.1";
    static final String readerClassName = "uk.co.mmscomputing.imageio.bmp.BMPImageReader";
    static final String[] names = new String[]{"bmp", "BMP"};
    static final String[] suffixes = new String[]{"bmp", "BMP"};
    static final String[] MIMETypes = new String[]{"image/bmp"};
    static final String[] writerSpiNames = new String[]{"uk.co.mmscomputing.imageio.bmp.BMPImageWriterSpi"};
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName = null;
    static final String nativeStreamMetadataFormatClassName = null;
    static final String[] extraStreamMetadataFormatNames = null;
    static final String[] extraStreamMetadataFormatClassNames = null;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = "uk.co.mmscomputing.imageio.bmp.BMPMetadata 0.0.1";
    static final String nativeImageMetadataFormatClassName = "uk.co.mmscomputing.imageio.bmp.BMPMetadata";
    static final String[] extraImageMetadataFormatNames = null;
    static final String[] extraImageMetadataFormatClassNames = null;

    public BMPImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, STANDARD_INPUT_TYPE, writerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public ImageReader createReaderInstance(Object object) throws IOException {
        return new BMPImageReader(this);
    }

    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = new byte[2];
        try {
            imageInputStream.mark();
            imageInputStream.readFully(byArray);
            imageInputStream.reset();
        }
        catch (IOException iOException) {
            return false;
        }
        return byArray[0] == 66 && byArray[1] == 77;
    }

    public String getDescription(Locale locale) {
        return "mmsc bmp decoder";
    }
}

