/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.bmp;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.bmp.BMPConstants;
import uk.co.mmscomputing.imageio.bmp.BMPMetadata;

public class BMPImageWriter
extends ImageWriter
implements BMPConstants {
    private int size = 0;
    private int offset = 0;
    private int headerSize = 40;
    private int width;
    private int height;
    private int planes = 1;
    private int bitCount = 24;
    private int compression = 0;
    private int sizeImage;
    private int xPelsPerMeter = 2953;
    private int yPelsPerMeter = 2953;
    private int clrUsed = 0;
    private int clrImportant = 0;
    private int[] colortable = null;

    protected BMPImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canInsertImage(int n) throws IOException {
        super.canInsertImage(n);
        return n == 0;
    }

    int getColorsInPalette() {
        if (this.clrUsed != 0) {
            return this.clrUsed;
        }
        if (this.bitCount < 16) {
            return 1 << this.bitCount;
        }
        return 0;
    }

    int getHeaderSize() {
        int n = 54;
        n += this.getColorsInPalette() * 4;
        return n += this.compression == 3 ? 12 : 0;
    }

    private void writeHeader(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata) throws IOException {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        if (iIOMetadata != null && iIOMetadata instanceof BMPMetadata) {
            BMPMetadata bMPMetadata = (BMPMetadata)iIOMetadata;
            this.xPelsPerMeter = bMPMetadata.getXPixelsPerMeter();
            this.yPelsPerMeter = bMPMetadata.getYPixelsPerMeter();
        }
        this.offset = this.getHeaderSize();
        this.sizeImage = (this.width * this.bitCount + 31 >> 5 << 2) * this.height;
        this.size = this.offset + this.sizeImage;
        imageOutputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        imageOutputStream.writeByte(66);
        imageOutputStream.writeByte(77);
        imageOutputStream.writeInt(this.size);
        imageOutputStream.writeShort(0);
        imageOutputStream.writeShort(0);
        imageOutputStream.writeInt(this.offset);
        imageOutputStream.writeInt(this.headerSize);
        imageOutputStream.writeInt(this.width);
        imageOutputStream.writeInt(this.height);
        imageOutputStream.writeShort(this.planes);
        imageOutputStream.writeShort(this.bitCount);
        imageOutputStream.writeInt(this.compression);
        imageOutputStream.writeInt(this.sizeImage);
        imageOutputStream.writeInt(this.xPelsPerMeter);
        imageOutputStream.writeInt(this.yPelsPerMeter);
        imageOutputStream.writeInt(this.clrUsed);
        imageOutputStream.writeInt(this.clrImportant);
    }

    public void write(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata) throws IOException {
        this.writeHeader(imageOutputStream, bufferedImage, iIOMetadata);
        int[] nArray = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, this.width, this.height, nArray, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(this.getClass().getName() + ".write : Couldn't grab pixels from image !");
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.width * this.bitCount + 31 >> 5 << 2;
        int n7 = this.height - 1;
        byte[] byArray = new byte[n6 * this.height];
        for (n2 = 0; n2 < this.height; ++n2) {
            n3 = (n7 - n2) * this.width;
            n4 = n2 * n6;
            for (n = 0; n < this.width; ++n) {
                n5 = n3 + n;
                byArray[n4++] = (byte)(colorModel.getBlue(nArray[n5]) & 0xFF);
                byArray[n4++] = (byte)(colorModel.getGreen(nArray[n5]) & 0xFF);
                byArray[n4++] = (byte)(colorModel.getRed(nArray[n5]) & 0xFF);
            }
        }
        imageOutputStream.write(byArray);
    }

    void writeColorTable(ImageOutputStream imageOutputStream, IndexColorModel indexColorModel) throws IOException {
        byte[] byArray = new byte[this.clrUsed];
        byte[] byArray2 = new byte[this.clrUsed];
        byte[] byArray3 = new byte[this.clrUsed];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < byArray.length; ++i) {
            imageOutputStream.write(byArray3[i]);
            imageOutputStream.write(byArray2[i]);
            imageOutputStream.write(byArray[i]);
            imageOutputStream.write(0);
        }
    }

    void writeImage(ImageOutputStream imageOutputStream, byte[] byArray, int n) throws IOException {
        int n2 = (this.width * this.bitCount + 31 >> 5 << 2) - n;
        for (int i = (this.height - 1) * n; i >= 0; i -= n) {
            imageOutputStream.write(byArray, i, n);
            for (int j = 0; j < n2; ++j) {
                imageOutputStream.write(0);
            }
        }
    }

    private void write01bit(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata, IndexColorModel indexColorModel) throws IOException {
        System.out.println("Save as 1 bit BMP");
        this.bitCount = 1;
        this.compression = 0;
        this.clrUsed = indexColorModel.getMapSize();
        this.writeHeader(imageOutputStream, bufferedImage, iIOMetadata);
        this.writeColorTable(imageOutputStream, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.writeImage(imageOutputStream, dataBufferByte.getData(), this.width + 7 >> 3);
    }

    private void write04bit(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata, IndexColorModel indexColorModel) throws IOException {
        System.out.println("Save as 4 bit BMP");
        this.bitCount = 4;
        this.compression = 0;
        this.clrUsed = indexColorModel.getMapSize();
        this.writeHeader(imageOutputStream, bufferedImage, iIOMetadata);
        this.writeColorTable(imageOutputStream, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.writeImage(imageOutputStream, dataBufferByte.getData(), this.width + 1 >> 1);
    }

    private void write08bit(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata, IndexColorModel indexColorModel) throws IOException {
        System.out.println("Save as 8 bit BMP");
        this.bitCount = 8;
        this.compression = 0;
        this.clrUsed = indexColorModel.getMapSize();
        this.writeHeader(imageOutputStream, bufferedImage, iIOMetadata);
        this.writeColorTable(imageOutputStream, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.writeImage(imageOutputStream, dataBufferByte.getData(), this.width);
    }

    private void write16bit(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata) throws IOException {
        System.out.println("Save as 8 bit BMP");
        this.bitCount = 16;
        this.compression = 3;
        this.clrUsed = 0;
        this.writeHeader(imageOutputStream, bufferedImage, iIOMetadata);
        imageOutputStream.writeInt(31744);
        imageOutputStream.writeInt(992);
        imageOutputStream.writeInt(31);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n = (this.width * this.bitCount + 31 >> 5 << 2) - (this.width << 1);
        for (int i = (this.height - 1) * this.width; i >= 0; i -= this.width) {
            imageOutputStream.writeShorts(sArray, i, this.width);
            if (n == 0) continue;
            imageOutputStream.write(0);
            imageOutputStream.write(0);
        }
    }

    private void write24bit(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata) throws IOException {
        this.bitCount = 24;
        this.compression = 0;
        this.clrUsed = 0;
        this.writeHeader(imageOutputStream, bufferedImage, iIOMetadata);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.writeImage(imageOutputStream, dataBufferByte.getData(), this.width * 3);
    }

    private void write32bit(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, IIOMetadata iIOMetadata) throws IOException {
        this.bitCount = 32;
        this.compression = 3;
        this.clrUsed = 0;
        this.writeHeader(imageOutputStream, bufferedImage, iIOMetadata);
        imageOutputStream.writeInt(0xFF0000);
        imageOutputStream.writeInt(65280);
        imageOutputStream.writeInt(255);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        for (int i = (this.height - 1) * this.width; i >= 0; i -= this.width) {
            imageOutputStream.writeInts(nArray, i, this.width);
        }
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + "write:\n\tCan only write BufferedImage objects");
        }
        IIOMetadata iIOMetadata2 = iIOImage.getMetadata();
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            if (bufferedImage.getType() == 12 && colorModel.getPixelSize() == 1) {
                this.write01bit(imageOutputStream, bufferedImage, iIOMetadata2, indexColorModel);
            } else if (bufferedImage.getType() == 12 && colorModel.getPixelSize() == 4) {
                this.write04bit(imageOutputStream, bufferedImage, iIOMetadata2, indexColorModel);
            } else if (bufferedImage.getType() == 13 && colorModel.getPixelSize() <= 8) {
                this.write08bit(imageOutputStream, bufferedImage, iIOMetadata2, indexColorModel);
            } else {
                this.write(imageOutputStream, bufferedImage, iIOMetadata2);
            }
        } else {
            switch (bufferedImage.getType()) {
                case 9: {
                    this.write16bit(imageOutputStream, bufferedImage, iIOMetadata2);
                    break;
                }
                case 5: {
                    this.write24bit(imageOutputStream, bufferedImage, iIOMetadata2);
                    break;
                }
                case 1: {
                    this.write32bit(imageOutputStream, bufferedImage, iIOMetadata2);
                    break;
                }
                default: {
                    this.write(imageOutputStream, bufferedImage, iIOMetadata2);
                }
            }
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }
}

