/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.gif;

import java.io.IOException;
import java.io.InputStream;

public class GIFBitInputStream
extends InputStream {
    private int buf;
    private int bitsAvail;
    protected boolean eof = false;
    protected int count;
    protected int max;
    protected byte[] data = new byte[255];
    protected InputStream in;

    public GIFBitInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        if (this.count == this.max) {
            this.max = this.in.read();
            if (this.max == 0) {
                return -1;
            }
            if (this.max < 0 || 255 < this.max) {
                throw new IOException(this.getClass().getName() + ".read:\n\tGIF data chunk length out of bounds [" + this.max + "]");
            }
            int n = this.in.read(this.data, 0, this.max);
            if (n != this.max) {
                throw new IOException(this.getClass().getName() + ".read:\n\tGIF data chunk missing.");
            }
            this.count = 0;
        }
        return this.data[this.count++] & 0xFF;
    }

    public int readBits(int n) throws IOException {
        if (this.eof && this.bitsAvail == 0) {
            return -1;
        }
        this.needBits(n);
        int n2 = this.getBits(n);
        this.clrBits(n);
        return n2;
    }

    protected void needBits(int n) throws IOException {
        while (!this.eof && this.bitsAvail < n) {
            int n2 = this.read();
            if (n2 == -1) {
                this.eof = true;
                break;
            }
            this.buf |= n2 << this.bitsAvail;
            this.bitsAvail += 8;
        }
    }

    protected void clrBits(int n) {
        this.bitsAvail -= n;
        this.buf >>= n;
    }

    protected int getBits(int n) {
        return this.buf & (1 << n) - 1;
    }
}

