/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.gif;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileCacheImageOutputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.gif.GIFImageWriteParam;
import uk.co.mmscomputing.imageio.gif.GIFLZWOutputStream;

public class GIFImageWriter
extends ImageWriter {
    private GIFFilterOutputStream out;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private Vector images = null;
    int colourCount = 0;
    int[] colourTable = new int[256];

    protected GIFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(this.getLocale());
    }

    public boolean canInsertImage(int n) throws IOException {
        super.canInsertImage(n);
        return n == 0;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.prepareWriteSequence(iIOMetadata);
        this.writeToSequence(iIOImage, imageWriteParam);
        this.endWriteSequence();
    }

    public boolean canWriteSequence() {
        return true;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.images = new Vector();
        this.colourCount = 0;
        this.out = new GIFFilterOutputStream((ImageOutputStream)this.getOutput());
        this.out.write(71);
        this.out.write(73);
        this.out.write(70);
        this.out.write(56);
        this.out.write(57);
        this.out.write(97);
        this.maxWidth = 256;
        this.maxHeight = 256;
        this.out.write(this.maxWidth & 0xFF);
        this.out.write(this.maxWidth >> 8 & 0xFF);
        this.out.write(this.maxHeight & 0xFF);
        this.out.write(this.maxHeight >> 8 & 0xFF);
        int n = 7;
        int n2 = 8;
        int n3 = n & 7;
        this.out.write(n3 |= (n2 - 1 & 7) << 4);
        this.out.write(0);
        this.out.write(0);
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + ".writeToSequence:\n\tCan only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        if (bufferedImage.getType() != 13 || bufferedImage.getColorModel().getPixelSize() != 8) {
            throw new IOException(this.getClass().getName() + ".writeToSequence:\n\tPlease convert image first to 8 bit 'Byte Indexed' colour model.");
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n > this.maxWidth) {
            this.maxWidth = n;
        }
        if (n2 > this.maxHeight) {
            this.maxHeight = n2;
        }
        int n3 = 7;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n6 = n3 & 7;
        if (bl2) {
            n6 |= 0x20;
        }
        if (bl) {
            n6 |= 0x40;
        }
        if (bl3) {
            n6 |= 0x80;
        }
        this.out.write(44);
        this.out.write(n4 & 0xFF);
        this.out.write(n4 >> 8 & 0xFF);
        this.out.write(n5 & 0xFF);
        this.out.write(n5 >> 8 & 0xFF);
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
        this.out.write(n6);
        this.writeColorTable((IndexColorModel)bufferedImage.getColorModel());
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        GIFLZWOutputStream gIFLZWOutputStream = new GIFLZWOutputStream(this.out, n3 + 1);
        gIFLZWOutputStream.write(byArray);
        gIFLZWOutputStream.flush();
    }

    public void endWriteSequence() throws IOException {
        this.out.write(59);
        this.out.flush();
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        if (imageOutputStream instanceof FileCacheImageOutputStream) {
            ((FileCacheImageOutputStream)imageOutputStream).seek(6L);
            imageOutputStream.write(this.maxWidth & 0xFF);
            imageOutputStream.write(this.maxWidth >> 8 & 0xFF);
            imageOutputStream.write(this.maxHeight & 0xFF);
            imageOutputStream.write(this.maxHeight >> 8 & 0xFF);
        } else if (imageOutputStream instanceof FileImageOutputStream) {
            ((FileImageOutputStream)imageOutputStream).seek(6L);
            imageOutputStream.write(this.maxWidth & 0xFF);
            imageOutputStream.write(this.maxWidth >> 8 & 0xFF);
            imageOutputStream.write(this.maxHeight & 0xFF);
            imageOutputStream.write(this.maxHeight >> 8 & 0xFF);
        }
        imageOutputStream.flush();
    }

    private void writeColorTable(IndexColorModel indexColorModel) throws IOException {
        int n;
        int n2 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (n = 0; n < n2; ++n) {
            this.out.write(byArray[n]);
            this.out.write(byArray2[n]);
            this.out.write(byArray3[n]);
        }
        for (n = n2; n < 256; ++n) {
            this.out.write(255);
            this.out.write(255);
            this.out.write(255);
        }
    }

    public static class GIFFilterOutputStream
    extends OutputStream {
        private ImageOutputStream out;
        private byte[] buffer;
        private int count;
        private int max;

        public GIFFilterOutputStream(ImageOutputStream imageOutputStream) {
            this.out = imageOutputStream;
            this.buffer = new byte[4096];
            this.count = 0;
        }

        public void write(int n) throws IOException {
            if (this.count == this.buffer.length) {
                this.out.write(this.buffer, 0, this.count);
                this.count = 0;
            }
            this.buffer[this.count++] = (byte)n;
        }

        public void flush() throws IOException {
            if (this.count > 0) {
                this.out.write(this.buffer, 0, this.count);
                this.count = 0;
            }
        }
    }
}

