/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.gif;

import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.gif.GIFBitOutputStream;

public class GIFLZWOutputStream
extends OutputStream {
    private static final int MAXCODE = 4096;
    private static final int PREFIXTABLE = 16;
    private int[] prefix = new int[4096];
    private int[] suffix = new int[4096];
    private int[][] prefixtab = new int[4096][16];
    private int curPrefix;
    private int curSuffix;
    private int dataSize;
    private int clearCode;
    private int eoiCode;
    private int availCode;
    private int codeSize;
    private GIFBitOutputStream out;

    public GIFLZWOutputStream(OutputStream outputStream, int n) throws IOException {
        this.out = new GIFBitOutputStream(outputStream);
        this.dataSize = n;
        this.resetTables();
        this.out.write(this.dataSize);
        this.curPrefix = 4096;
        this.out.writeBits(this.clearCode, this.codeSize);
    }

    private void resetTables() {
        int n;
        this.codeSize = this.dataSize + 1;
        this.clearCode = 1 << this.dataSize;
        this.eoiCode = this.clearCode + 1;
        this.availCode = this.clearCode + 2;
        for (n = 0; n < this.availCode; ++n) {
            this.prefix[n] = 4096;
            this.suffix[n] = n;
        }
        for (n = 0; n < 4096; ++n) {
            for (int i = 0; i < 16; ++i) {
                this.prefixtab[n][i] = 4096;
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            this.write(byArray[i] & 0xFF);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i] & 0xFF);
        }
    }

    public void write(int n) throws IOException {
        int n2;
        int[] nArray;
        if (n == this.clearCode) {
            this.curPrefix = 4096;
            this.out.writeBits(n, this.codeSize);
            return;
        }
        this.curSuffix = n;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = 4096;
        if (this.curPrefix < 4096) {
            nArray = this.prefixtab[this.curPrefix];
            for (n2 = 0; n2 < 16; ++n2) {
                n3 = nArray[n2];
                if (n3 == 4096) {
                    bl = false;
                    break;
                }
                if (this.suffix[n3] != this.curSuffix) continue;
                bl2 = true;
                break;
            }
        }
        if (this.curPrefix == 4096 || !bl2 && bl) {
            int n4;
            n3 = 4096;
            int n5 = n4 = this.curPrefix == 4096 ? 0 : this.clearCode + 2;
            while (n4 < this.availCode) {
                if (this.prefix[n4] == this.curPrefix && this.suffix[n4] == this.curSuffix) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
        }
        if (n3 != 4096) {
            this.curPrefix = n3;
            return;
        }
        if (this.availCode == 4096) {
            this.out.writeBits(this.curPrefix, this.codeSize);
            this.out.writeBits(this.clearCode, this.codeSize);
            this.resetTables();
            this.curPrefix = n;
        } else {
            this.prefix[this.availCode] = this.curPrefix;
            this.suffix[this.availCode] = this.curSuffix;
            nArray = this.prefixtab[this.curPrefix];
            for (n2 = 0; n2 < 16; ++n2) {
                if (nArray[n2] != 4096) continue;
                nArray[n2] = this.availCode;
                break;
            }
            this.out.writeBits(this.curPrefix, this.codeSize);
            this.codeSize = this.getCodeLength(this.availCode);
            ++this.availCode;
            this.curPrefix = this.curSuffix;
        }
    }

    private int getCodeLength(int n) {
        if ((n & 0x800) != 0) {
            return 12;
        }
        if ((n & 0x400) != 0) {
            return 11;
        }
        if ((n & 0x200) != 0) {
            return 10;
        }
        if ((n & 0x100) != 0) {
            return 9;
        }
        if ((n & 0x80) != 0) {
            return 8;
        }
        if ((n & 0x40) != 0) {
            return 7;
        }
        if ((n & 0x20) != 0) {
            return 6;
        }
        if ((n & 0x10) != 0) {
            return 5;
        }
        if ((n & 8) != 0) {
            return 4;
        }
        return 3;
    }

    public void flush() throws IOException {
        this.out.writeBits(this.curPrefix, this.codeSize);
        this.out.writeBits(this.eoiCode, this.codeSize);
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

