/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGInputStream;

public class JPEGBitInputStream
extends FilterInputStream
implements JPEGConstants {
    JPEGInputStream jpeg;
    private int bitBuffer;
    private int bitCount;

    public JPEGBitInputStream(InputStream inputStream, JPEGInputStream jPEGInputStream) throws IOException {
        super(inputStream);
        this.jpeg = jPEGInputStream;
    }

    private int readIn() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            IOException iOException = new IOException(this.getClass().getName() + "readIn:\n\tUnexpected end of file.");
            iOException.printStackTrace();
            throw iOException;
        }
        return n;
    }

    protected InputStream readMarkedSegment() throws IOException {
        int n = (this.readIn() << 8 | this.readIn()) - 2;
        byte[] byArray = new byte[n];
        int n2 = this.in.read(byArray);
        if (n2 != n) {
            throw new IOException(this.getClass().getName() + ".readMarkedSegment:\n\tUnexpected end of file.");
        }
        return new ByteArrayInputStream(byArray);
    }

    public int readCompressed() throws IOException {
        int n;
        block32: while ((n = this.readIn()) == 255) {
            int n2;
            while ((n2 = this.readIn()) == 255) {
            }
            switch (n2) {
                case 0: {
                    return 255;
                }
                case 192: 
                case 193: {
                    this.jpeg.startOfFrame(this.readMarkedSegment(), n2 & 0xF);
                    continue block32;
                }
                case 196: {
                    this.jpeg.defineHuffmanTables(this.readMarkedSegment());
                    continue block32;
                }
                case 204: {
                    this.jpeg.defineArithmeticConditioning(this.readMarkedSegment());
                    continue block32;
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    this.jpeg.restartIntervalTermination(n2 & 7);
                    this.bitBuffer = 0;
                    this.bitCount = 0;
                    continue block32;
                }
                case 216: {
                    this.jpeg.startOfImage();
                    continue block32;
                }
                case 217: {
                    this.jpeg.endOfImage();
                    return -1;
                }
                case 218: {
                    this.jpeg.startOfScan(this.readMarkedSegment());
                    this.bitCount = 0;
                    continue block32;
                }
                case 219: {
                    this.jpeg.defineQuantizationTables(this.readMarkedSegment());
                    continue block32;
                }
                case 220: {
                    this.jpeg.defineNumberOfLines(this.readMarkedSegment());
                    continue block32;
                }
                case 221: {
                    this.jpeg.defineRestartInterval(this.readMarkedSegment());
                    continue block32;
                }
                case 222: {
                    this.jpeg.defineHierarchicalProgression(this.readMarkedSegment());
                    continue block32;
                }
                case 223: {
                    this.jpeg.expandReferenceComponents(this.readMarkedSegment());
                    continue block32;
                }
                case 224: {
                    this.jpeg.app0(this.readMarkedSegment());
                    continue block32;
                }
                case 225: {
                    this.jpeg.app1(this.readMarkedSegment());
                    continue block32;
                }
                case 226: {
                    this.jpeg.app2(this.readMarkedSegment());
                    continue block32;
                }
                case 227: {
                    this.jpeg.app3(this.readMarkedSegment());
                    continue block32;
                }
                case 228: {
                    this.jpeg.app4(this.readMarkedSegment());
                    continue block32;
                }
                case 229: {
                    this.jpeg.app5(this.readMarkedSegment());
                    continue block32;
                }
                case 230: {
                    this.jpeg.app6(this.readMarkedSegment());
                    continue block32;
                }
                case 231: {
                    this.jpeg.app7(this.readMarkedSegment());
                    continue block32;
                }
                case 232: {
                    this.jpeg.app8(this.readMarkedSegment());
                    continue block32;
                }
                case 233: {
                    this.jpeg.app9(this.readMarkedSegment());
                    continue block32;
                }
                case 234: {
                    this.jpeg.app10(this.readMarkedSegment());
                    continue block32;
                }
                case 235: {
                    this.jpeg.app11(this.readMarkedSegment());
                    continue block32;
                }
                case 236: {
                    this.jpeg.app12(this.readMarkedSegment());
                    continue block32;
                }
                case 237: {
                    this.jpeg.app13(this.readMarkedSegment());
                    continue block32;
                }
                case 238: {
                    this.jpeg.app14(this.readMarkedSegment());
                    continue block32;
                }
                case 239: {
                    this.jpeg.app15(this.readMarkedSegment());
                    continue block32;
                }
                case 254: {
                    this.jpeg.comment(this.readMarkedSegment());
                    continue block32;
                }
            }
            throw new IOException(this.getClass().getName() + ".readCompressed:\n\tUnknown marker = " + Integer.toHexString(n2));
        }
        return n;
    }

    public void start() throws IOException {
        int n = this.readCompressed();
        if (n == -1) {
            return;
        }
        this.bitBuffer = n << 24;
        this.bitCount = 8;
    }

    public int readBit() throws IOException {
        int n;
        if (this.bitCount == 0) {
            n = this.readCompressed();
            if (n == -1) {
                return -1;
            }
            this.bitBuffer = n << 24;
            this.bitCount = 8;
        }
        n = this.bitBuffer >>> 31;
        this.bitBuffer <<= 1;
        --this.bitCount;
        return n;
    }

    public int readBits(int n) throws IOException {
        int n2;
        if (n == 0) {
            return 0;
        }
        while (this.bitCount < n) {
            n2 = this.readCompressed();
            if (n2 == -1) {
                return -1;
            }
            this.bitBuffer |= n2 << 24 - this.bitCount;
            this.bitCount += 8;
        }
        n2 = this.bitBuffer >>> 32 - n;
        this.bitBuffer <<= n;
        this.bitCount -= n;
        return n2;
    }
}

