/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;

public class JPEGComponentsOutputStream
extends OutputStream
implements JPEGConstants {
    protected OutputStream[] outs;
    protected byte[][] buffer;
    protected int[] H;
    protected int[] V;
    protected int HMax;
    protected int VMax;
    protected int xMCUStep;
    protected int yMCUStep;
    protected int width;
    protected int ww;
    protected int y;
    protected int x;
    protected int comp;
    protected int spp;

    public JPEGComponentsOutputStream(OutputStream[] outputStreamArray, int[] nArray, int n) throws IOException {
        this.outs = outputStreamArray;
        this.width = n;
        this.y = 0;
        this.x = 0;
        this.comp = 0;
        this.spp = nArray.length;
        this.H = new int[this.spp];
        this.V = new int[this.spp];
        this.HMax = 0;
        this.VMax = 0;
        for (int i = 0; i < this.spp; ++i) {
            this.H[i] = nArray[i] >> 4 & 0xF;
            this.V[i] = nArray[i] & 0xF;
            if (this.HMax < this.H[i]) {
                this.HMax = this.H[i];
            }
            if (this.VMax >= this.V[i]) continue;
            this.VMax = this.V[i];
        }
        this.xMCUStep = this.HMax * 8;
        this.yMCUStep = this.VMax * 8;
        this.ww = (n + this.xMCUStep - 1) / this.xMCUStep * this.xMCUStep;
        this.buffer = new byte[this.spp][this.ww * this.yMCUStep];
    }

    protected void writeDataUnit(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = this.VMax - n + 1;
        int n5 = this.HMax - n2 + 1;
        for (int i = 0; i < 8 * n4; i += n4) {
            for (int j = 0; j < 8 * n5; j += n5) {
                int n6 = 0;
                for (int k = 0; k < n4; ++k) {
                    for (int i2 = 0; i2 < n5; ++i2) {
                        n6 += byArray[n3 + (i + k) * this.ww + (j + i2)] & 0xFF;
                    }
                }
                outputStream.write(n6 /= n4 * n5);
            }
        }
    }

    protected void writeMCU(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        for (int i = 0; i < n; ++i) {
            int n4 = i * 8 * this.ww;
            for (int j = 0; j < n2; ++j) {
                int n5 = n3 + j * 8;
                this.writeDataUnit(outputStream, byArray, n, n2, n4 + n5);
            }
        }
    }

    protected void writeMCUs() throws IOException {
        for (int i = 0; i < this.ww; i += this.xMCUStep) {
            for (int j = 0; j < this.spp; ++j) {
                this.writeMCU(this.outs[j], this.buffer[j], this.V[j], this.H[j], i);
            }
        }
    }

    public void write(int n) throws IOException {
        this.buffer[this.comp++][this.y * this.ww + this.x] = (byte)n;
        if (this.comp == this.spp) {
            this.comp = 0;
            ++this.x;
        }
        if (this.x == this.width) {
            if (this.x < this.ww) {
                for (int i = 0; i < this.spp; ++i) {
                    byte[] byArray = this.buffer[i];
                    byte by = byArray[this.y * this.ww + this.width - 1];
                    for (int j = this.width; j < this.ww; ++j) {
                        byArray[this.y * this.ww + j] = by;
                    }
                }
            }
            this.x = 0;
            ++this.y;
        }
        if (this.y == this.yMCUStep) {
            this.y = 0;
            this.writeMCUs();
        }
    }

    public void flush() throws IOException {
        if (this.y > 0) {
            for (int i = 0; i < this.spp; ++i) {
                byte[] byArray = this.buffer[i];
                for (int j = this.y; j < this.yMCUStep; ++j) {
                    for (int k = 0; k < this.ww; ++k) {
                        byArray[j * this.ww + k] = byArray[(this.y - 1) * this.ww + k];
                    }
                }
            }
            this.writeMCUs();
        }
        this.y = 0;
        this.x = 0;
        this.comp = 0;
    }
}

