/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.io.IOException;
import uk.co.mmscomputing.imageio.jpeg.JPEGACInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGDCInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGHuffmanInputStream;

public class JPEGDCTInputStream
extends JPEGACInputStream {
    protected JPEGDCInputStream dc;
    protected int levelshift;
    protected int negclamp;
    protected int posclamp;
    protected int[] matr1 = new int[64];

    public JPEGDCTInputStream(JPEGHuffmanInputStream jPEGHuffmanInputStream, JPEGHuffmanInputStream jPEGHuffmanInputStream2, int[] nArray, int n) {
        super(jPEGHuffmanInputStream2, nArray);
        this.dc = new JPEGDCInputStream(jPEGHuffmanInputStream);
        this.levelshift = 1 << n - 1;
        this.negclamp = -this.levelshift;
        this.posclamp = this.levelshift - 1;
    }

    public void restart() throws IOException {
        this.dc.restart();
        super.restart();
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    protected void levelShift() {
        for (int i = 0; i < 64; ++i) {
            int n = this.buffer[i];
            if (n < this.negclamp) {
                n = this.negclamp;
            } else if (n > this.posclamp) {
                n = this.posclamp;
            }
            this.buffer[i] = n += this.levelshift;
        }
    }

    public void fillBuffer() throws IOException {
        this.buffer[0] = this.qt[0] * this.dc.read();
        super.fillBuffer();
        this.inverseDCT(this.buffer);
        this.levelShift();
        this.count = 0;
    }

    public int read() throws IOException {
        if (this.count == 64) {
            this.fillBuffer();
        }
        return this.buffer[this.count++];
    }

    public void inverseDCT(int[] nArray) throws IOException {
        double[] dArray = new double[]{1.0 / Math.sqrt(2.0), 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                double d = 0.0;
                for (int k = 0; k < 8; ++k) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        d += dArray[i2] * dArray[k] * (double)nArray[k * 8 + i2] * Math.cos((2.0 * (double)j + 1.0) / 16.0 * (double)i2 * Math.PI) * Math.cos((2.0 * (double)i + 1.0) / 16.0 * (double)k * Math.PI);
                    }
                }
                this.matr1[i * 8 + j] = (int)Math.round(d /= 4.0);
            }
        }
        System.arraycopy(this.matr1, 0, nArray, 0, 64);
    }
}

