/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.jpeg.JFIFInputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGInputStream;
import uk.co.mmscomputing.io.IntFilterInputStream;

public class JPEGImageReader
extends ImageReader {
    JFIFInputStream is = null;
    BufferedImage image = null;

    protected JPEGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        if (this.image == null) {
            this.image = this.read((ImageInputStream)this.getInput());
        }
        return this.image;
    }

    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        if (this.image == null) {
            this.image = this.read((ImageInputStream)this.getInput());
        }
        return this.is.getHeight();
    }

    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        if (this.image == null) {
            this.image = this.read((ImageInputStream)this.getInput());
        }
        return this.is.getWidth();
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        if (this.image == null) {
            this.image = this.read((ImageInputStream)this.getInput());
        }
        ImageTypeSpecifier imageTypeSpecifier = null;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        switch (this.is.getNumComponents()) {
            case 1: {
                imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(10);
                break;
            }
            case 3: {
                imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            }
        }
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".checkIndex: Bad index in jpeg image reader");
        }
    }

    private BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".read: ImageInputStream is null.");
        }
        BufferedImage bufferedImage = null;
        try {
            byte[] byArray;
            Closeable closeable;
            int n = (int)imageInputStream.length();
            if (n == -1) {
                closeable = new ByteArrayOutputStream();
                byArray = new byte[16384];
                while ((n = imageInputStream.read(byArray)) != -1) {
                    ((ByteArrayOutputStream)closeable).write(byArray, 0, n);
                }
                byArray = ((ByteArrayOutputStream)closeable).toByteArray();
            } else {
                if (n == 0) {
                    throw new IllegalArgumentException(this.getClass().getName() + ".read: ImageInputStream has length zero.");
                }
                byArray = new byte[n];
                imageInputStream.readFully(byArray);
            }
            closeable = new JFIFInputStream(new ByteArrayInputStream(byArray));
            int n2 = ((JPEGInputStream)closeable).getHeight();
            int n3 = ((JPEGInputStream)closeable).getWidth();
            int n4 = ((JPEGInputStream)closeable).getNumComponents();
            if (n4 == 1) {
                bufferedImage = new BufferedImage(n3, n2, 10);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                byte[] byArray2 = dataBufferByte.getData();
                ((FilterInputStream)closeable).read(byArray2);
            } else {
                bufferedImage = new BufferedImage(n3, n2, 1);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                int[] nArray = dataBufferInt.getData();
                ((IntFilterInputStream)closeable).read(nArray);
            }
        }
        catch (Exception exception) {
            System.out.println("9\b" + exception.getMessage());
            exception.printStackTrace();
        }
        return bufferedImage;
    }
}

