/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.jpeg;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.jpeg.JFIFOutputStream;

public class JPEGImageWriter
extends ImageWriter {
    protected JPEGImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }

    public boolean canInsertImage(int n) throws IOException {
        return n == 0;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + "write:\nCan only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (bufferedImage.getType() == 10) {
                JFIFOutputStream jFIFOutputStream = new JFIFOutputStream(byteArrayOutputStream, false, n2, n);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                byte[] byArray = dataBufferByte.getData();
                jFIFOutputStream.write(byArray);
                jFIFOutputStream.close();
            } else if (bufferedImage.getType() == 1) {
                JFIFOutputStream jFIFOutputStream = new JFIFOutputStream(byteArrayOutputStream, true, n2, n);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                int[] nArray = dataBufferInt.getData();
                jFIFOutputStream.write(nArray);
                jFIFOutputStream.close();
            } else {
                JFIFOutputStream jFIFOutputStream = new JFIFOutputStream(byteArrayOutputStream, true, n2, n);
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        jFIFOutputStream.write(bufferedImage.getRGB(j, i));
                    }
                }
                jFIFOutputStream.close();
            }
            imageOutputStream.write(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".write:\n\tCould not write image due to :\n\t" + exception.getMessage());
        }
    }
}

