/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import uk.co.mmscomputing.imageio.pdf.PDFConstants;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;

public class PDFCrossReferenceEntry
implements PDFConstants {
    private boolean isInUse;
    private int offset;
    private int objectNumber;
    private int generationNumber;
    private PDFIndirectObject object;

    public PDFCrossReferenceEntry(int n) {
        this.isInUse = true;
        this.offset = 0;
        this.objectNumber = n;
        this.generationNumber = 0;
        this.object = null;
    }

    public PDFCrossReferenceEntry(int n, int n2) {
        this.isInUse = false;
        this.offset = 0;
        this.objectNumber = n;
        this.generationNumber = n2;
        this.object = null;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }

    public void setObject(PDFIndirectObject pDFIndirectObject) {
        this.object = pDFIndirectObject;
    }

    public PDFIndirectObject getObject() {
        return this.object;
    }

    public PDFObject getDirectObject() {
        return this.object.getDirectObject();
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        pDFScanner.scan();
        if (pDFScanner.symbol != 201) {
            throw new IOException(this.getClass().getName() + ".read:\n\tSubsection Entry: Byte offset.");
        }
        this.offset = pDFScanner.intval;
        pDFScanner.scan();
        if (pDFScanner.symbol != 201) {
            throw new IOException(this.getClass().getName() + ".read:\n\tSubsection Entry: Generation number.");
        }
        this.generationNumber = pDFScanner.intval;
        pDFScanner.scan();
        if (pDFScanner.symbol == 411) {
            this.isInUse = true;
        } else if (pDFScanner.symbol == 412) {
            this.isInUse = false;
        } else {
            throw new IOException(this.getClass().getName() + ".read:\n\tSubsection Entry: Missing <n>|<f> keyword.");
        }
    }

    private void write(PDFFile pDFFile, int n, int n2) throws IOException {
        byte[] byArray = new byte[n];
        int n3 = n - 1;
        while (n2 > 0) {
            if (n3 < 0) {
                throw new IllegalArgumentException(this.getClass().getName() + ".write:\n\tNumber too big!");
            }
            byArray[n3] = (byte)(48 + n2 % 10);
            n2 /= 10;
            --n3;
        }
        while (n3 >= 0) {
            byArray[n3] = 48;
            --n3;
        }
        pDFFile.write(byArray);
        pDFFile.write(' ');
    }

    public void write(PDFFile pDFFile) throws IOException {
        if (this.isInUse) {
            this.write(pDFFile, 10, this.offset);
            this.write(pDFFile, 5, this.generationNumber);
            pDFFile.write('n');
        } else {
            this.write(pDFFile, 10, this.objectNumber);
            this.write(pDFFile, 5, this.generationNumber);
            pDFFile.write('f');
        }
        pDFFile.write(' ');
        pDFFile.write('\n');
    }

    public String toString() {
        String string = "";
        if (this.isInUse) {
            string = string + this.offset + " ";
            string = string + this.generationNumber + " n";
        } else {
            string = string + this.objectNumber + " ";
            string = string + this.generationNumber + " f";
        }
        return string;
    }
}

