/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.mmscomputing.imageio.pdf.PDFConstants;
import uk.co.mmscomputing.imageio.pdf.PDFCrossReferenceEntry;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;

public class PDFCrossReferenceTable
implements PDFConstants {
    private PDFCrossReferenceEntry[] entries = null;
    private Vector sections = new Vector();

    public PDFCrossReferenceTable(int n) {
        this.entries = new PDFCrossReferenceEntry[n];
    }

    public PDFCrossReferenceEntry[] getEntries() {
        return this.entries;
    }

    public PDFCrossReferenceTable() {
    }

    public void add(PDFCrossReferenceEntry pDFCrossReferenceEntry) {
        this.add(0, 0, pDFCrossReferenceEntry);
    }

    public void add(int n, int n2, PDFCrossReferenceEntry pDFCrossReferenceEntry) {
        while (this.sections.size() <= n) {
            this.sections.add(new PDFCrossReferenceSection());
        }
        ((PDFCrossReferenceSection)this.sections.elementAt(n)).add(n2, pDFCrossReferenceEntry);
    }

    public int getLastCrossReferenceSectionOffset() {
        return ((PDFCrossReferenceSection)this.sections.lastElement()).getOffset();
    }

    public int size() {
        int n = 0;
        Enumeration enumeration = this.sections.elements();
        while (enumeration.hasMoreElements()) {
            PDFCrossReferenceSection pDFCrossReferenceSection = (PDFCrossReferenceSection)enumeration.nextElement();
            n += pDFCrossReferenceSection.size();
        }
        return n;
    }

    public void write(PDFFile pDFFile) throws IOException {
        Enumeration enumeration = this.sections.elements();
        while (enumeration.hasMoreElements()) {
            PDFCrossReferenceSection pDFCrossReferenceSection = (PDFCrossReferenceSection)enumeration.nextElement();
            pDFCrossReferenceSection.write(pDFFile);
        }
    }

    public PDFCrossReferenceEntry getEntry(int n) {
        return this.entries[n];
    }

    public void read(PDFScanner pDFScanner) throws IOException {
        int n = 0;
        if (pDFScanner.symbol == 408) {
            do {
                PDFCrossReferenceSection pDFCrossReferenceSection = new PDFCrossReferenceSection();
                this.sections.add(pDFCrossReferenceSection);
                n = pDFCrossReferenceSection.read(pDFScanner, this.entries, n);
            } while (pDFScanner.symbol == 408);
        } else {
            throw new IOException(this.getClass().getName() + ".read:\n\tExpect symbol <xref>");
        }
    }

    public static class PDFCrossReferenceSubSection {
        private int first = -1;
        private Vector entries = new Vector();

        public void add(PDFCrossReferenceEntry pDFCrossReferenceEntry) {
            this.entries.add(pDFCrossReferenceEntry);
        }

        public int size() {
            return this.entries.size();
        }

        public int read(PDFScanner pDFScanner, PDFCrossReferenceEntry[] pDFCrossReferenceEntryArray, int n) throws IOException {
            pDFScanner.scan();
            if (pDFScanner.symbol != 201) {
                throw new IOException(this.getClass().getName() + ".read:\n\tSubsection: Missing object number of first entry.");
            }
            this.first = pDFScanner.intval;
            pDFScanner.scan();
            if (pDFScanner.symbol != 201) {
                throw new IOException(this.getClass().getName() + ".read:\n\tSubsection: Missing number of entries.");
            }
            int n2 = pDFScanner.intval;
            for (int i = 0; i < n2; ++i) {
                PDFCrossReferenceEntry pDFCrossReferenceEntry = new PDFCrossReferenceEntry(n);
                pDFCrossReferenceEntry.read(pDFScanner);
                pDFCrossReferenceEntryArray[n++] = pDFCrossReferenceEntry;
            }
            return n;
        }

        public void write(PDFFile pDFFile) throws IOException {
            Enumeration enumeration = this.entries.elements();
            if (enumeration.hasMoreElements()) {
                PDFCrossReferenceEntry pDFCrossReferenceEntry = (PDFCrossReferenceEntry)enumeration.nextElement();
                pDFFile.write(pDFCrossReferenceEntry.getObjectNumber());
                pDFFile.write(' ');
                pDFFile.write(this.entries.size());
                pDFFile.writeln();
                pDFCrossReferenceEntry.write(pDFFile);
                while (enumeration.hasMoreElements()) {
                    pDFCrossReferenceEntry = (PDFCrossReferenceEntry)enumeration.nextElement();
                    pDFCrossReferenceEntry.write(pDFFile);
                }
            }
        }
    }

    public static class PDFCrossReferenceSection {
        private Vector subsections = new Vector();
        private int offset = -1;

        public int getOffset() {
            return this.offset;
        }

        public void add(int n, PDFCrossReferenceEntry pDFCrossReferenceEntry) {
            while (this.subsections.size() <= n) {
                this.subsections.add(new PDFCrossReferenceSubSection());
            }
            ((PDFCrossReferenceSubSection)this.subsections.elementAt(n)).add(pDFCrossReferenceEntry);
        }

        public int size() {
            int n = 0;
            Enumeration enumeration = this.subsections.elements();
            while (enumeration.hasMoreElements()) {
                PDFCrossReferenceSubSection pDFCrossReferenceSubSection = (PDFCrossReferenceSubSection)enumeration.nextElement();
                n += pDFCrossReferenceSubSection.size();
            }
            return n;
        }

        public int read(PDFScanner pDFScanner, PDFCrossReferenceEntry[] pDFCrossReferenceEntryArray, int n) throws IOException {
            do {
                PDFCrossReferenceSubSection pDFCrossReferenceSubSection = new PDFCrossReferenceSubSection();
                this.subsections.add(pDFCrossReferenceSubSection);
                n = pDFCrossReferenceSubSection.read(pDFScanner, pDFCrossReferenceEntryArray, n);
                pDFScanner.scan();
            } while (pDFScanner.symbol == 201);
            return n;
        }

        public void write(PDFFile pDFFile) throws IOException {
            this.offset = pDFFile.getOffset();
            pDFFile.writeln("xref");
            Enumeration enumeration = this.subsections.elements();
            while (enumeration.hasMoreElements()) {
                PDFCrossReferenceSubSection pDFCrossReferenceSubSection = (PDFCrossReferenceSubSection)enumeration.nextElement();
                pDFCrossReferenceSubSection.write(pDFFile);
            }
        }
    }
}

