/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import uk.co.mmscomputing.imageio.pdf.PDFArray;
import uk.co.mmscomputing.imageio.pdf.PDFBody;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectReference;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFPage;

public class PDFDocument {

    public static class PDFPages
    extends PDFDictionary {
        private PDFBody body;
        private PDFIndirectReference parent;
        private PDFIndirectReference ref;
        private PDFArray kids;

        public PDFPages(PDFBody pDFBody, PDFIndirectReference pDFIndirectReference) {
            this.body = pDFBody;
            this.parent = pDFIndirectReference;
            this.ref = pDFBody.getIndirectReference(this);
            this.kids = new PDFArray();
            this.put("Type", new PDFObject.PDFName("Pages"));
            this.put("Kids", this.kids);
            this.put("Count", new PDFObject.PDFInteger(0));
            if (pDFIndirectReference != null) {
                this.put("Parent", pDFIndirectReference);
            }
        }

        public PDFIndirectReference getReference() {
            return this.ref;
        }

        public PDFPage getNewPage() {
            PDFPage pDFPage = new PDFPage(this.body, this);
            this.kids.add(pDFPage.getReference());
            return pDFPage;
        }

        public void addResource(String string, PDFIndirectObject pDFIndirectObject) {
            PDFDictionary pDFDictionary = (PDFDictionary)this.get("Resources");
            if (pDFDictionary == null) {
                pDFDictionary = new PDFDictionary();
                this.put("Resources", pDFDictionary);
            }
            pDFDictionary.put(string, new PDFIndirectReference(pDFIndirectObject));
        }

        public void write(PDFFile pDFFile) throws IOException {
            this.put("Count", new PDFObject.PDFInteger(this.kids.size()));
            super.write(pDFFile);
        }
    }

    public static class PDFOutlineTree
    extends PDFDictionary {
        public PDFOutlineTree() {
            this.put("Type", new PDFObject.PDFName("Outlines"));
            this.put("Count", new PDFObject.PDFInteger(0));
        }
    }
}

