/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.pdf.PDFBody;
import uk.co.mmscomputing.imageio.pdf.PDFCatalog;
import uk.co.mmscomputing.imageio.pdf.PDFConstants;
import uk.co.mmscomputing.imageio.pdf.PDFCrossReferenceEntry;
import uk.co.mmscomputing.imageio.pdf.PDFCrossReferenceTable;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFImage;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectReference;
import uk.co.mmscomputing.imageio.pdf.PDFInfo;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFPage;
import uk.co.mmscomputing.imageio.pdf.PDFScanner;

public class PDFFile
implements PDFConstants {
    private PDFHeader header = new PDFHeader();
    private PDFInfo info;
    private PDFBody body;
    private PDFCrossReferenceTable crossReferenceTable = new PDFCrossReferenceTable();
    private PDFTrailer trailer;
    private OutputStream out;
    private ImageInputStream in;

    public PDFFile() {
        this.body = new PDFBody(this.crossReferenceTable);
        this.info = new PDFInfo(this.body);
        this.trailer = new PDFTrailer();
    }

    public PDFBody getBody() {
        return this.body;
    }

    public PDFCatalog getCatalog() {
        return this.body.getCatalog();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.out = outputStream;
        this.header.write(this);
        this.body.write(this);
        this.crossReferenceTable.write(this);
        this.trailer.put("Size", this.body.getSize());
        this.trailer.put("Root", this.body.getRoot());
        this.trailer.setInfo(this.info);
        this.trailer.write(this, this.crossReferenceTable.getLastCrossReferenceSectionOffset());
    }

    public int getOffset() {
        return ((ByteArrayOutputStream)this.out).size();
    }

    public void write(byte by) throws IOException {
        this.out.write(by);
    }

    public void write(char c) throws IOException {
        this.out.write((byte)c);
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public void write(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void writeln(String string) throws IOException {
        this.write(string.getBytes());
        this.write('\n');
    }

    public void write(int n) throws IOException {
        this.write(Integer.toString(n));
    }

    public void writeln() throws IOException {
        this.write('\n');
    }

    public void read(ImageInputStream imageInputStream) throws IOException {
        int n;
        PDFScanner pDFScanner = new PDFScanner(this.body, imageInputStream);
        this.header.read(pDFScanner);
        this.trailer.read(pDFScanner);
        pDFScanner.seek(this.trailer.getStartXRef());
        this.crossReferenceTable = new PDFCrossReferenceTable(this.trailer.getSize());
        this.crossReferenceTable.read(pDFScanner);
        PDFCrossReferenceEntry[] pDFCrossReferenceEntryArray = this.crossReferenceTable.getEntries();
        for (n = 1; n < pDFCrossReferenceEntryArray.length; ++n) {
            PDFCrossReferenceEntry pDFCrossReferenceEntry = this.crossReferenceTable.getEntry(n);
            PDFIndirectObject pDFIndirectObject = this.body.getIndirectObject(pDFCrossReferenceEntry.getObjectNumber(), pDFCrossReferenceEntry.getGenerationNumber());
            pDFIndirectObject.setOffset(pDFCrossReferenceEntry.getOffset());
        }
        int n2 = 0;
        do {
            n = 0;
            for (int i = 1; i < pDFCrossReferenceEntryArray.length; ++i) {
                PDFCrossReferenceEntry pDFCrossReferenceEntry = this.crossReferenceTable.getEntry(i);
                if (pDFCrossReferenceEntry.getObject() != null) continue;
                PDFIndirectObject pDFIndirectObject = this.body.getIndirectObject(pDFCrossReferenceEntry.getObjectNumber(), pDFCrossReferenceEntry.getGenerationNumber());
                pDFScanner.seek(pDFCrossReferenceEntry.getOffset());
                try {
                    pDFIndirectObject.read(pDFScanner);
                    pDFCrossReferenceEntry.setObject(pDFIndirectObject);
                    continue;
                }
                catch (Exception exception) {
                    n = 1;
                }
            }
        } while (n != 0 && ++n2 < 10);
    }

    public PDFPage getNewPage() {
        return this.body.getCatalog().getNewPage();
    }

    public BufferedImage getImage(int n) throws IOException {
        int n2 = this.trailer.getSize();
        int n3 = 0;
        for (int i = 1; i < n2; ++i) {
            PDFCrossReferenceEntry pDFCrossReferenceEntry = this.crossReferenceTable.getEntry(i);
            PDFObject pDFObject = pDFCrossReferenceEntry.getDirectObject();
            if (!(pDFObject instanceof PDFImage)) continue;
            if (n3 == n) {
                return ((PDFImage)pDFObject).getImage();
            }
            ++n3;
        }
        return null;
    }

    public static class PDFIncrementalUpdate {
    }

    public static class PDFTrailer
    extends PDFDictionary {
        private int xref = -1;

        public void setStartXRef(int n) {
            this.xref = n;
        }

        public int getStartXRef() {
            return this.xref;
        }

        public int getSize() {
            return ((PDFObject.PDFInteger)this.get("Size")).getValue();
        }

        public PDFIndirectObject getRoot() {
            return ((PDFIndirectReference)this.get("Root")).getIndirectObject();
        }

        public void setInfo(PDFInfo pDFInfo) {
            if (pDFInfo != null) {
                this.put("Info", pDFInfo.getReference());
            }
        }

        public void read(PDFScanner pDFScanner) throws IOException {
            pDFScanner.seek(pDFScanner.getLength() - 256L);
            pDFScanner.find(410);
            pDFScanner.scan();
            super.read(pDFScanner);
            pDFScanner.scan();
            if (pDFScanner.symbol != 409) {
                throw new IOException(this.getClass().getName() + ".read:\n\tTrailer: Cannot find keyword <startxref>.");
            }
            pDFScanner.scanStartXRefNumber();
            if (pDFScanner.symbol != 201) {
                throw new IOException(this.getClass().getName() + ".read:\n\tTrailer: Cannot find startxref value.");
            }
            this.xref = pDFScanner.intval;
        }

        public void write(PDFFile pDFFile, int n) throws IOException {
            pDFFile.writeln("trailer");
            super.write(pDFFile);
            pDFFile.writeln("startxref");
            pDFFile.write(n);
            pDFFile.writeln();
            pDFFile.write("%%EOF");
        }
    }

    public static class PDFHeader {
        private String header = "PDF-1.1";

        public void write(PDFFile pDFFile) throws IOException {
            pDFFile.writeln("%" + this.header);
            pDFFile.write("%");
            pDFFile.write((byte)-127);
            pDFFile.write((byte)-127);
            pDFFile.write((byte)-127);
            pDFFile.write((byte)-127);
            pDFFile.writeln();
        }

        public void read(PDFScanner pDFScanner) throws IOException {
            this.header = pDFScanner.scanComment();
        }
    }
}

