/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.mmscomputing.imageio.pdf.PDFCrossReferenceTable;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;
import uk.co.mmscomputing.imageio.pdf.PDFObject;

public class PDFIndirectObjects {
    private Vector list = new Vector();

    public PDFIndirectObjects() {
        this.addNotInUse(65535);
    }

    public int getSize() {
        return this.list.size();
    }

    public PDFIndirectObject add(PDFObject pDFObject) {
        PDFIndirectObject pDFIndirectObject = new PDFIndirectObject(this.list.size(), pDFObject);
        this.list.add(pDFIndirectObject);
        return pDFIndirectObject;
    }

    public PDFIndirectObject add(int n, int n2) {
        PDFIndirectObject pDFIndirectObject;
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            pDFIndirectObject = (PDFIndirectObject)enumeration.nextElement();
            if (pDFIndirectObject.getObjectNumber() != n || pDFIndirectObject.getGenerationNumber() != n2) continue;
            return pDFIndirectObject;
        }
        pDFIndirectObject = new PDFIndirectObject(n, n2, true);
        this.list.add(pDFIndirectObject);
        return pDFIndirectObject;
    }

    public void addNotInUse(int n) {
        this.list.add(new PDFIndirectObject(this.list.size(), n, false));
    }

    public void write(PDFFile pDFFile) throws IOException {
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            ((PDFObject)enumeration.nextElement()).write(pDFFile);
        }
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ((PDFObject)enumeration.nextElement()).toString();
        }
        return string;
    }

    public void setXRefTable(PDFCrossReferenceTable pDFCrossReferenceTable) {
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            PDFIndirectObject pDFIndirectObject = (PDFIndirectObject)enumeration.nextElement();
            pDFCrossReferenceTable.add(pDFIndirectObject.getXRefEntry());
        }
    }
}

