/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.co.mmscomputing.imageio.pdf.PDFBody;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFFile;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectReference;
import uk.co.mmscomputing.imageio.pdf.PDFObject;

public class PDFInfo
extends PDFDictionary {
    private static String defaultAuthor = "mm's computing";
    private static String defaultCreator = "http://www.mms-computing.co.uk/";
    private static String defaultProducer = "http://www.mms-computing.co.uk/";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private PDFIndirectReference ref;

    public PDFInfo(PDFBody pDFBody) {
        this.ref = pDFBody.getIndirectReference(this);
        this.setAuthor(defaultAuthor);
        this.setCreator(defaultCreator);
        this.setProducer(defaultProducer);
        this.setCreationDate(new Date());
        this.setTitle("An mm's computing document!");
    }

    public PDFIndirectReference getReference() {
        return this.ref;
    }

    public static void setDefaultAuthor(String string) {
        defaultAuthor = string;
    }

    public void setAuthor(String string) {
        this.put("Author", new PDFObject.PDFString(string));
    }

    public String getAuthor() {
        return ((PDFObject.PDFString)this.get("Author")).getValue();
    }

    public static void setDefaultDateFormat(String string) {
        sdf = new SimpleDateFormat(string);
    }

    public void setCreationDate(Date date) {
        this.setCreationDate(sdf.format(date));
    }

    public void setCreationDate(String string) {
        this.put("CreationDate", new PDFObject.PDFString(string));
    }

    public String getCreationDate() {
        return ((PDFObject.PDFString)this.get("CreationDate")).getValue();
    }

    public void setModDate(Date date) {
        this.setModDate(sdf.format(date));
    }

    public void setModDate(String string) {
        this.put("ModDate", new PDFObject.PDFString(string));
    }

    public String getModDate() {
        return ((PDFObject.PDFString)this.get("ModDate")).getValue();
    }

    public static void setDefaultCreator(String string) {
        defaultCreator = string;
    }

    public void setCreator(String string) {
        this.put("Creator", new PDFObject.PDFString(string));
    }

    public String getCreator() {
        return ((PDFObject.PDFString)this.get("Creator")).getValue();
    }

    public static void setDefaultProducer(String string) {
        defaultProducer = string;
    }

    public void setProducer(String string) {
        this.put("Producer", new PDFObject.PDFString(string));
    }

    public String getProducer() {
        return ((PDFObject.PDFString)this.get("Producer")).getValue();
    }

    public void setTitle(String string) {
        this.put("Title", new PDFObject.PDFString(string));
    }

    public String getTitle() {
        return ((PDFObject.PDFString)this.get("Title")).getValue();
    }

    public void write(PDFFile pDFFile) throws IOException {
        super.write(pDFFile);
    }
}

