/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import uk.co.mmscomputing.imageio.pdf.PDFArray;
import uk.co.mmscomputing.imageio.pdf.PDFBody;
import uk.co.mmscomputing.imageio.pdf.PDFDictionary;
import uk.co.mmscomputing.imageio.pdf.PDFDocument;
import uk.co.mmscomputing.imageio.pdf.PDFImage;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectReference;
import uk.co.mmscomputing.imageio.pdf.PDFObject;
import uk.co.mmscomputing.imageio.pdf.PDFStream;

public class PDFPage
extends PDFDictionary {
    private PDFBody body;
    private PDFDocument.PDFPages parent;
    private PDFIndirectReference ref;
    private PDFArray contents;

    public PDFPage(PDFBody pDFBody, PDFDocument.PDFPages pDFPages) {
        this.body = pDFBody;
        this.parent = pDFPages;
        this.ref = pDFBody.getIndirectReference(this);
        this.contents = null;
        this.put("Type", new PDFObject.PDFName("Page"));
        this.setMediaBox(0, 0, 613, 793);
        this.put("Parent", pDFPages.getReference());
    }

    public PDFIndirectReference getReference() {
        return this.ref;
    }

    public PDFDocument.PDFPages getParent() {
        return this.parent;
    }

    public void setMediaBox(int n, int n2, int n3, int n4) {
        PDFArray pDFArray = new PDFArray();
        pDFArray.add(new PDFObject.PDFInteger(n));
        pDFArray.add(new PDFObject.PDFInteger(n2));
        pDFArray.add(new PDFObject.PDFInteger(n + n3));
        pDFArray.add(new PDFObject.PDFInteger(n2 + n4));
        this.put("MediaBox", pDFArray);
    }

    public void addResource(String string, PDFObject pDFObject) {
        PDFDictionary pDFDictionary = (PDFDictionary)this.get("Resources");
        if (pDFDictionary == null) {
            pDFDictionary = new PDFDictionary();
            this.put("Resources", pDFDictionary);
        }
        pDFDictionary.put(string, pDFObject);
    }

    public void addResource(String string, PDFIndirectObject pDFIndirectObject) {
        PDFDictionary pDFDictionary = (PDFDictionary)this.get("Resources");
        if (pDFDictionary == null) {
            pDFDictionary = new PDFDictionary();
            this.put("Resources", pDFDictionary);
        }
        pDFDictionary.put(string, new PDFIndirectReference(pDFIndirectObject));
    }

    public boolean haveResource(String string) {
        PDFDictionary pDFDictionary = (PDFDictionary)this.get("Resources");
        if (pDFDictionary == null) {
            return false;
        }
        return pDFDictionary.get(string) != null;
    }

    public void setContents(PDFIndirectObject pDFIndirectObject) {
        if (this.contents == null) {
            this.contents = new PDFArray();
            this.put("Contents", this.contents);
        }
        this.contents.add(pDFIndirectObject);
    }

    public void setCropBox(int n, int n2, int n3, int n4) {
        PDFArray pDFArray = new PDFArray();
        pDFArray.add(new PDFObject.PDFInteger(n));
        pDFArray.add(new PDFObject.PDFInteger(n2));
        pDFArray.add(new PDFObject.PDFInteger(n + n3));
        pDFArray.add(new PDFObject.PDFInteger(n2 + n4));
        this.put("CropBox", pDFArray);
    }

    public void addDefaultFont() {
        PDFIndirectReference pDFIndirectReference = this.body.getDefaultFont();
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("defaultFont", pDFIndirectReference);
        this.addResource("Font", pDFDictionary);
    }

    public void addPostScript(byte[] byArray) {
        if (!this.haveResource("Font")) {
            this.addDefaultFont();
        }
        PDFStream pDFStream = new PDFStream();
        PDFIndirectObject pDFIndirectObject = this.body.getIndirectObject(pDFStream);
        pDFStream.setInputStream(new ByteArrayInputStream(byArray));
        this.setContents(pDFIndirectObject);
    }

    public void addText(int n, int n2, int n3, String string) {
        String string2 = "BT\n";
        string2 = string2 + "/defaultFont " + n3 + " Tf\n";
        string2 = string2 + "" + n + " " + n2 + " Td(" + string + ") Tj\n";
        string2 = string2 + "ET";
        this.addPostScript(string2.getBytes());
    }

    public void addImage(String string, BufferedImage bufferedImage) throws IOException {
        PDFDictionary pDFDictionary = (PDFDictionary)this.get("Resources");
        if (pDFDictionary == null) {
            pDFDictionary = new PDFDictionary();
            this.put("Resources", pDFDictionary);
        }
        PDFArray pDFArray = new PDFArray();
        pDFArray.add(new PDFObject.PDFName("PDF"));
        pDFArray.add(new PDFObject.PDFName("Text"));
        pDFArray.add(new PDFObject.PDFName("ImageB"));
        pDFArray.add(new PDFObject.PDFName("ImageC"));
        PDFIndirectObject pDFIndirectObject = this.body.getIndirectObject(pDFArray);
        pDFDictionary.put("ProcSet", new PDFIndirectReference(pDFIndirectObject));
        PDFDictionary pDFDictionary2 = (PDFDictionary)pDFDictionary.get("XObject");
        if (pDFDictionary2 == null) {
            pDFDictionary2 = new PDFDictionary();
            pDFDictionary.put("XObject", pDFDictionary2);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.setMediaBox(0, 0, n, n2);
        PDFImage pDFImage = new PDFImage(string, bufferedImage);
        pDFIndirectObject = this.body.getIndirectObject(pDFImage);
        pDFDictionary2.put(string, new PDFIndirectReference(pDFIndirectObject));
        PDFStream pDFStream = new PDFStream();
        pDFIndirectObject = this.body.getIndirectObject(pDFStream);
        String string2 = "q\n";
        string2 = string2 + Integer.toString(n) + " 0 0 " + Integer.toString(n2) + " 0 0 cm\n";
        string2 = string2 + "/" + string + " Do\n";
        string2 = string2 + "Q\n";
        pDFStream.setInputStream(new ByteArrayInputStream(string2.getBytes()));
        this.setContents(pDFIndirectObject);
    }
}

