/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.pdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.pdf.PDFBody;
import uk.co.mmscomputing.imageio.pdf.PDFConstants;
import uk.co.mmscomputing.imageio.pdf.PDFIndirectObject;

public class PDFScanner
implements PDFConstants {
    private static int[] charTable;
    private static Dictionary keywords;
    private ImageInputStream in;
    private int c;
    private int sym;
    public int intval;
    public double realval;
    public String name = "";
    public String str;
    public int symbol;
    private long length;
    private PDFBody body;
    private int rmax = 3;
    private int rindex = 0;
    public int[] rvalues = new int[this.rmax];
    private int[] rsymbols = new int[this.rmax];
    public int objectNumber;
    public int generationNumber;

    public PDFScanner(PDFBody pDFBody, ImageInputStream imageInputStream) throws IOException {
        this.body = pDFBody;
        this.in = imageInputStream;
        this.c = 32;
        this.symbol = 0;
        this.length = -1L;
    }

    public PDFIndirectObject getIndirectObject(int n, int n2) {
        return this.body.getIndirectObject(n, n2);
    }

    public void seek(long l) throws IOException {
        this.in.seek(l);
        this.c = 32;
        this.symbol = 0;
        this.rindex = 0;
        this.scan();
    }

    public long getLength() throws IOException {
        if (this.length == -1L) {
            this.length = this.in.length();
            if (this.length == -1L) {
                int n;
                byte[] byArray = new byte[32768];
                this.length = 0L;
                while ((n = this.in.read(byArray, 0, byArray.length)) != -1) {
                    this.length += (long)n;
                }
            }
        }
        return this.length;
    }

    public void find(int n) throws IOException {
        do {
            this.scan();
            if (this.symbol != -1) continue;
            throw new IOException(this.getClass().getName() + ".find\n\t Cannot find token: " + n + ". Unexpected EOF.");
        } while (this.symbol != n);
    }

    private void read() throws IOException {
        this.c = this.in.read();
        this.sym = this.c != -1 ? charTable[this.c] : -1;
    }

    public String readLine() throws IOException {
        int n;
        String string = "";
        while ((n = this.in.read()) != -1 && n != 10 && n != 13) {
        }
        return string;
    }

    public void scanEOL() throws IOException {
        while (this.c != 13 && this.c != 10 && this.c != -1) {
            this.read();
        }
        if (this.c == 13) {
            this.read();
            if (this.c == 10) {
                this.read();
            }
        } else if (this.c == 10) {
            this.read();
        }
    }

    public byte[] scanStream(byte[] byArray) throws IOException {
        this.scanEOL();
        if (this.c == -1) {
            throw new IOException(this.getClass().getName() + ".readStream:\n\t Unexpected EOF.");
        }
        byArray[0] = (byte)this.c;
        int n = this.in.read(byArray, 1, byArray.length - 1) + 1;
        if (n != byArray.length) {
            throw new IOException(this.getClass().getName() + ".readStream:\n\t Not enough bytes in inputstream! [" + n + " != " + byArray.length + "]");
        }
        this.read();
        return byArray;
    }

    public byte[] scanStream(int n) throws IOException {
        return this.scanStream(new byte[n]);
    }

    public String scanComment() throws IOException {
        this.str = "";
        this.read();
        while (this.c != 10 && this.c != 13 && this.c != -1) {
            this.str = this.str + (char)this.c;
            this.read();
        }
        if (this.c == 13) {
            this.read();
            if (this.c == 10) {
                this.read();
            }
        } else if (this.c == 10) {
            this.read();
        }
        return this.str;
    }

    private void scanName() throws IOException {
        this.str = "";
        this.read();
        while (this.sym == 200 || this.sym == 201) {
            this.str = this.str + (char)this.c;
            this.read();
        }
        this.symbol = 306;
    }

    private void scanString() throws IOException {
        this.str = "";
        this.read();
        while (this.sym != 301) {
            if (32 <= this.c && this.c <= 127) {
                if (this.c == 92) {
                    this.read();
                    if (this.c == 10 || this.c == 13) {
                        this.read();
                        continue;
                    }
                    if (this.c == 116) {
                        this.c = 9;
                    } else if (this.c == 98) {
                        this.c = 8;
                    } else if (this.c == 102) {
                        this.c = 12;
                    } else if (this.c == 92) {
                        this.c = 92;
                    } else if (this.c == 40) {
                        this.c = 40;
                    } else if (this.c == 41) {
                        this.c = 41;
                    } else if (48 > this.c || this.c <= 55) {
                        // empty if block
                    }
                }
                this.str = this.str + (char)this.c;
            } else {
                System.err.println(this.getClass().getName() + ".scanLiteral:\n\tInvalid character[0x" + Integer.toHexString(this.c) + "] in literal.");
            }
            this.read();
        }
        this.read();
        this.symbol = 203;
    }

    private void scanHexString() throws IOException {
        this.str = "";
        while (this.c != 62) {
            int n = 0;
            int n2 = 0;
            if (this.c == -1) {
                System.err.println(this.getClass().getName() + ".scanHexString:\n\tMissing '>'");
                break;
            }
            if (48 <= this.c && this.c <= 57) {
                n = this.c - 48;
            } else if (65 <= this.c && this.c <= 70) {
                n = this.c - 65 + 10;
            } else if (97 <= this.c && this.c <= 102) {
                n = this.c - 97 + 10;
            } else {
                System.err.println(this.getClass().getName() + ".scanHexString:\n\tWrong character '" + (char)this.c + "'");
            }
            this.read();
            if (this.c == -1) {
                System.err.println(this.getClass().getName() + ".scanHexString:\n\tMissing '>'");
                break;
            }
            if (this.c == 62) {
                n2 = 0;
            } else {
                if (48 <= this.c && this.c <= 57) {
                    n2 = this.c - 48;
                } else if (65 <= this.c && this.c <= 70) {
                    n2 = this.c - 65 + 10;
                } else if (97 <= this.c && this.c <= 102) {
                    n2 = this.c - 97 + 10;
                } else {
                    System.err.println(this.getClass().getName() + ".scanHexString:\n\tWrong character '" + (char)this.c + "'");
                }
                this.read();
            }
            char c = (char)(n << 4 | n2);
            this.str = this.str + c;
        }
        this.read();
        this.symbol = 203;
    }

    private void scanIdentifier() throws IOException {
        this.str = "";
        while (this.sym == 200 || this.sym == 201) {
            this.str = this.str + (char)this.c;
            this.read();
        }
        this.name = this.str;
        Integer n = (Integer)keywords.get(this.name);
        this.symbol = n != null ? n : 306;
    }

    private void scanReal() throws IOException {
        this.symbol = 202;
        this.realval = this.intval;
        this.scanNumber();
    }

    private void scanNumber() throws IOException {
        int[] nArray = new int[11];
        boolean bl = false;
        nArray[0] = this.c - 48;
        int n = 0;
        while (true) {
            if (n == nArray.length - 1) {
                System.err.println(this.getClass().getName() + ".scanNumber:\n\tToo many digits[" + n + "] in number.");
                break;
            }
            this.read();
            ++n;
            if (this.c == 46 || this.c < 48) break;
            if (this.c <= 57) {
                nArray[n] = this.c - 48;
                continue;
            }
            if (97 <= this.c && this.c <= 102) {
                bl = true;
                nArray[n] = this.c - 97 + 10;
                continue;
            }
            if (65 > this.c || this.c > 70) break;
            bl = true;
            nArray[n] = this.c - 65 + 10;
        }
        if (this.c == 46) {
            this.read();
            this.scanReal();
            return;
        }
        if (this.c == 72 || this.c == 104) {
            int n2;
            this.read();
            for (n2 = 0; n - n2 != 8 && n - n2 != 4 && n - n2 != 2 && n2 < n - 1 && nArray[n2] == 0; ++n2) {
            }
            if (n > 8) {
                n2 = n - 8;
            }
            this.intval = nArray[n2];
            if (this.intval >= 8) {
                this.intval -= 16;
            }
            ++n2;
            while (n2 < n) {
                this.intval = this.intval * 16 + nArray[n2];
                ++n2;
            }
            this.symbol = 201;
        } else if (!bl) {
            int n3;
            for (n3 = 0; n3 < n - 1 && nArray[n3] == 0; ++n3) {
            }
            this.intval = 0;
            do {
                this.intval = this.intval * 10 + nArray[n3];
            } while (++n3 < n);
            if (this.c == 88) {
                this.read();
                if (this.intval < 0 || 255 < this.intval) {
                    System.err.println(this.getClass().getName() + ".scanNumber:\n\tChar ordinal[" + this.intval + "] out of range.");
                }
                this.symbol = 200;
            } else {
                this.symbol = 201;
            }
        } else {
            System.err.println(this.getClass().getName() + ".scanNumber:\n\tInvalid number.");
            this.intval = 0;
            this.symbol = 0;
        }
        this.intval = this.intval;
    }

    public void scanStartXRefNumber() throws IOException {
        this.symbol = 0;
        while (this.sym == 0) {
            this.read();
        }
        if (this.sym != 201) {
            throw new IOException(this.getClass().getName() + ".scanStartXRefNumber:\n\tMissing startXRef offset.");
        }
        this.scanNumber();
    }

    private void scan1() throws IOException {
        this.symbol = 0;
        while (this.sym == 0) {
            this.read();
        }
        switch (this.sym) {
            case 200: {
                this.scanIdentifier();
                break;
            }
            case 201: {
                this.scanNumberR();
                break;
            }
            case 306: {
                this.scanName();
                break;
            }
            case 300: {
                this.scanString();
                break;
            }
            case 103: {
                this.read();
                if (this.sym == 103) {
                    this.symbol = 304;
                    this.read();
                    break;
                }
                this.scanHexString();
                break;
            }
            case 307: {
                this.scanComment();
                this.scan1();
                break;
            }
            case 104: {
                this.read();
                if (this.sym != 104) break;
                this.symbol = 305;
                this.read();
                break;
            }
            default: {
                this.symbol = this.sym;
                this.read();
            }
        }
    }

    private void scanNumberR1() throws IOException {
        if (this.rindex < this.rmax) {
            while (this.sym == 0) {
                this.read();
            }
            if (this.sym == 201) {
                this.scanNumberR();
            } else {
                this.scan1();
                this.rsymbols[this.rindex++] = this.symbol;
            }
        }
    }

    private void scanNumberR() throws IOException {
        this.scanNumber();
        this.rsymbols[this.rindex] = this.symbol;
        this.rvalues[this.rindex] = this.intval;
        ++this.rindex;
        this.scanNumberR1();
    }

    private void remove() {
        this.intval = this.rvalues[0];
        this.symbol = this.rsymbols[0];
        --this.rindex;
        for (int i = 0; i < this.rindex; ++i) {
            this.rvalues[i] = this.rvalues[i + 1];
            this.rsymbols[i] = this.rsymbols[i + 1];
        }
    }

    public void scan() throws IOException {
        if (this.rindex > 0) {
            if (this.rsymbols[this.rindex - 1] == 201) {
                this.scanNumberR1();
                if (this.symbol == 407) {
                    this.rindex -= 2;
                    this.generationNumber = this.rvalues[this.rindex];
                    --this.rindex;
                    this.objectNumber = this.rvalues[this.rindex];
                    this.rsymbols[this.rindex++] = this.symbol;
                }
            }
            this.remove();
        } else {
            this.scan1();
            if (this.symbol == 407) {
                this.rindex -= 2;
                this.generationNumber = this.rvalues[this.rindex];
                --this.rindex;
                this.objectNumber = this.rvalues[this.rindex];
            } else if (this.rindex > 0) {
                this.remove();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "335566\n%%EOF\n [1] [1 2 ] [1 2 3] [1 2 3 4] [1 2 3 4 5] [1 2 R] [0 1 2 R] [0 1 R 2 3 R] [0 1 2 3 4 R] [0 1 2 3 4  5 R] [0 1 0 R 2 0 R 3 0][0] [0 1] (Klasse wie geht's\\t?\\\n Hallo)  true \\ << 101 10.2 >>  [false  null]  /NA***;_ME<41>  %comment\n <4142303961>";
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            PDFScanner pDFScanner = new PDFScanner(null, imageInputStream);
            block16: while (pDFScanner.symbol != -1) {
                pDFScanner.scan();
                switch (pDFScanner.symbol) {
                    case 203: {
                        System.err.println("string = " + pDFScanner.str);
                        continue block16;
                    }
                    case 306: {
                        System.err.println("name   = " + pDFScanner.str);
                        continue block16;
                    }
                    case 402: {
                        System.err.println("true   = " + pDFScanner.str);
                        continue block16;
                    }
                    case 401: {
                        System.err.println("false  = " + pDFScanner.str);
                        continue block16;
                    }
                    case 400: {
                        System.err.println("null   = " + pDFScanner.str);
                        continue block16;
                    }
                    case 201: {
                        System.err.println("int = " + pDFScanner.intval);
                        continue block16;
                    }
                    case 202: {
                        System.err.println("real = " + pDFScanner.realval);
                        continue block16;
                    }
                    case 302: {
                        System.err.println("array start");
                        continue block16;
                    }
                    case 303: {
                        System.err.println("array end");
                        continue block16;
                    }
                    case 304: {
                        System.err.println("dict start");
                        continue block16;
                    }
                    case 305: {
                        System.err.println("dict end");
                        continue block16;
                    }
                    case 407: {
                        System.err.println("R " + pDFScanner.objectNumber + " " + pDFScanner.generationNumber);
                        continue block16;
                    }
                }
                System.err.println("symbol    = " + pDFScanner.symbol);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        int n;
        charTable = new int[256];
        for (n = 0; n < 256; ++n) {
            PDFScanner.charTable[n] = 0;
        }
        for (n = 33; n < 127; ++n) {
            PDFScanner.charTable[n] = 200;
        }
        for (n = 48; n <= 57; ++n) {
            PDFScanner.charTable[n] = 201;
        }
        PDFScanner.charTable[37] = 307;
        PDFScanner.charTable[40] = 300;
        PDFScanner.charTable[41] = 301;
        PDFScanner.charTable[60] = 103;
        PDFScanner.charTable[62] = 104;
        PDFScanner.charTable[91] = 302;
        PDFScanner.charTable[93] = 303;
        PDFScanner.charTable[123] = 109;
        PDFScanner.charTable[125] = 110;
        PDFScanner.charTable[47] = 306;
        keywords = new Hashtable();
        keywords.put("null", new Integer(400));
        keywords.put("false", new Integer(401));
        keywords.put("true", new Integer(402));
        keywords.put("stream", new Integer(403));
        keywords.put("endstream", new Integer(404));
        keywords.put("obj", new Integer(405));
        keywords.put("endobj", new Integer(406));
        keywords.put("R", new Integer(407));
        keywords.put("xref", new Integer(408));
        keywords.put("trailer", new Integer(410));
        keywords.put("startxref", new Integer(409));
        keywords.put("n", new Integer(411));
        keywords.put("f", new Integer(412));
    }
}

