/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.ppm;

import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.image.operators.Binarization;
import uk.co.mmscomputing.image.operators.GrayScale;
import uk.co.mmscomputing.imageio.ppm.PPMConstants;

public class PBMImageWriter
extends ImageWriter
implements PPMConstants {
    protected PBMImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canInsertImage(int n) throws IOException {
        super.canInsertImage(n);
        return n == 0;
    }

    public void pbm(ImageOutputStream imageOutputStream, BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n, n2, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(this.getClass().getName() + ".pbm: couldn't grab pixels from image !");
        }
        int n3 = n % 8 == 0 ? n >> 3 : n + 8 >> 3;
        String string = "P4\n" + n + " " + n2 + "\n";
        imageOutputStream.write(string.getBytes());
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n4 = 0;
        byte[] byArray = new byte[n3 * n2];
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n && n4 < byArray.length) {
                byte by = 0;
                for (int j = 7; j >= 0 && n5 < n; --j) {
                    int n6;
                    if ((n6 = writableRaster.getSample(n5++, i, 0)) != 0) continue;
                    by = (byte)(by | 1 << j);
                }
                byArray[n4++] = by;
            }
        }
        imageOutputStream.write(byArray);
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + "write: Can only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        switch (bufferedImage.getType()) {
            case 12: {
                break;
            }
            case 10: {
                bufferedImage = new Binarization().filter(bufferedImage);
                break;
            }
            default: {
                bufferedImage = new GrayScale().filter(bufferedImage);
                bufferedImage = new Binarization().filter(bufferedImage);
            }
        }
        this.pbm(imageOutputStream, bufferedImage);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }
}

