/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.ppm;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PPMImageReader
extends ImageReader {
    private boolean gotHeader = false;
    private static final int PBM_ASCII = 1;
    private static final int PGM_ASCII = 2;
    private static final int PPM_ASCII = 3;
    private static final int PBM_RAW = 4;
    private static final int PGM_RAW = 5;
    private static final int PPM_RAW = 6;
    private int format = -1;
    private int width = -1;
    private int height = -1;
    private int maxcolval = 0;

    protected PPMImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        return this.read((ImageInputStream)this.getInput());
    }

    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader((ImageInputStream)this.getInput());
        return this.height;
    }

    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader((ImageInputStream)this.getInput());
        return this.width;
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader((ImageInputStream)this.getInput());
        ImageTypeSpecifier imageTypeSpecifier = null;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".checkIndex: Bad index in ppm image reader");
        }
    }

    private char readAsciiChar(ImageInputStream imageInputStream) throws IOException {
        char c;
        do {
            if ((c = (char)imageInputStream.read()) != '#') continue;
            while ((c = (char)imageInputStream.read()) != '\n' && c != '\r') {
            }
        } while (c == ' ' || c == '\t' || c == '\n' || c == '\r');
        return c;
    }

    private int readAsciiInt(ImageInputStream imageInputStream) throws IOException {
        char c = this.readAsciiChar(imageInputStream);
        if (c < '0' || '9' < c) {
            throw new IOException(this.getClass().getName() + ".readAsciiInt: Expected ascii integer.");
        }
        int n = 0;
        do {
            n = n * 10 + c - 48;
        } while ('0' <= (c = (char)imageInputStream.read()) && c <= '9');
        return n;
    }

    private void readHeader(ImageInputStream imageInputStream) throws IOException {
        if (this.gotHeader) {
            return;
        }
        this.gotHeader = true;
        byte[] byArray = new byte[2];
        imageInputStream.readFully(byArray);
        if (byArray[0] != 80) {
            throw new IOException(this.getClass().getName() + ".readHeader: Invalid PPM File. Missing 'P'.");
        }
        this.format = byArray[1] - 48;
        switch (this.format) {
            case 1: 
            case 2: 
            case 3: {
                throw new IOException(this.getClass().getName() + ".readHeader: Unsupported ASCII PPM File Format : P" + byArray[1]);
            }
            case 4: {
                this.width = this.readAsciiInt(imageInputStream);
                this.height = this.readAsciiInt(imageInputStream);
                this.maxcolval = 1;
                break;
            }
            case 5: {
                this.width = this.readAsciiInt(imageInputStream);
                this.height = this.readAsciiInt(imageInputStream);
                this.maxcolval = this.readAsciiInt(imageInputStream);
                break;
            }
            case 6: {
                this.width = this.readAsciiInt(imageInputStream);
                this.height = this.readAsciiInt(imageInputStream);
                this.maxcolval = this.readAsciiInt(imageInputStream);
                break;
            }
            default: {
                throw new IOException("Invalid PPM File. Unknown Format [" + this.format + "]");
            }
        }
    }

    private BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        this.readHeader(imageInputStream);
        switch (this.format) {
            case 4: {
                byte[] byArray = new byte[this.width * this.height >> 3];
                imageInputStream.readFully(byArray);
                return PPMImageReader.pbm(this.width, this.height, byArray);
            }
            case 5: {
                byte[] byArray = new byte[this.width * this.height];
                imageInputStream.readFully(byArray);
                return PPMImageReader.pgm(this.width, this.height, this.maxcolval, byArray);
            }
            case 6: {
                byte[] byArray = new byte[this.width * this.height * 3];
                imageInputStream.readFully(byArray);
                return PPMImageReader.ppm(this.width, this.height, this.maxcolval, byArray);
            }
        }
        throw new IOException(this.getClass().getName() + ".read: Unsupported File Format.");
    }

    public static BufferedImage ppm(int n, int n2, int n3, byte[] byArray) {
        if (n3 < 256) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            int n4 = 0;
            if (n3 == 255) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 + 3 < byArray.length; ++j) {
                        byte by = byArray[n4++];
                        byte by2 = byArray[n4++];
                        byte by3 = byArray[n4++];
                        int n5 = -16777216 + (by << 16) + (by2 << 8) + by3;
                        bufferedImage.setRGB(j, i, n5);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 + 3 < byArray.length; ++j) {
                        int n6 = byArray[n4++];
                        n6 = (n6 * 255 + (n3 >> 1)) / n3;
                        int n7 = byArray[n4++];
                        n7 = (n7 * 255 + (n3 >> 1)) / n3;
                        int n8 = byArray[n4++];
                        n8 = (n8 * 255 + (n3 >> 1)) / n3;
                        int n9 = -16777216 + (n6 << 16) + (n7 << 8) + n8;
                        bufferedImage.setRGB(j, i, n9);
                    }
                }
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int n10 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n && n10 + 6 < byArray.length; ++j) {
                int n11 = byArray[n10++] | byArray[n10++] << 8;
                n11 = (n11 * 255 + (n3 >> 1)) / n3;
                int n12 = byArray[n10++] | byArray[n10++] << 8;
                n12 = (n12 * 255 + (n3 >> 1)) / n3;
                int n13 = byArray[n10++] | byArray[n10++] << 8;
                n13 = (n13 * 255 + (n3 >> 1)) / n3;
                int n14 = -16777216 + (n11 << 16) + (n12 << 8) + n13;
                bufferedImage.setRGB(j, i, n14);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage pgm(int n, int n2, int n3, byte[] byArray) {
        if (n3 < 256) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n4 = 0;
            if (n3 == 255) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 < byArray.length; ++j) {
                        writableRaster.setSample(j, i, 0, byArray[n4++]);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 < byArray.length; ++j) {
                        int n5 = (byArray[n4++] * 255 + (n3 >> 1)) / n3;
                        writableRaster.setSample(j, i, 0, n5);
                    }
                }
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 11);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n6 = 0;
        if (n3 == 65535) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n && n6 < byArray.length - 1; ++j) {
                    int n7 = byArray[n6++] | byArray[n6++] << 8;
                    writableRaster.setSample(j, i, 0, n7);
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n && n6 < byArray.length - 1; ++j) {
                    int n8 = byArray[n6++] | byArray[n6++] << 8;
                    int n9 = (n8 * 65535 + (n3 >> 1)) / n3;
                    writableRaster.setSample(j, i, 0, n9);
                }
            }
        }
        return bufferedImage;
    }

    public static BufferedImage pbm(int n, int n2, byte[] byArray) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 12);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = 0;
        int n4 = n % 8 == 0 ? n >> 3 : n + 8 >> 3;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4 && n3 < byArray.length; ++j) {
                byte by = byArray[n3++];
                for (int k = 0; k < 8; ++k) {
                    int n5 = (j << 3) + (7 - k);
                    if (n5 >= n) continue;
                    int n6 = (by & 1 << k) == 0 ? -1 : -16777216;
                    writableRaster.setSample(n5, i, 0, n6);
                }
            }
        }
        return bufferedImage;
    }
}

