/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.sff;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.sff.SFFOutputStream;
import uk.co.mmscomputing.io.ModHuffmanOutputStream;
import uk.co.mmscomputing.io.RLEBit1OutputStream;

public class SFFImageWriter
extends ImageWriter {
    private RLEBit1OutputStream rlos;
    private ModHuffmanOutputStream mhos;
    private SFFOutputStream sffos;
    private ByteArrayOutputStream baos;

    protected SFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }

    public boolean canInsertImage(int n) throws IOException {
        return n == 0;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.prepareWriteSequence(iIOMetadata);
        this.writeToSequence(iIOImage, imageWriteParam);
        this.endWriteSequence();
    }

    public boolean canWriteSequence() {
        return true;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.baos = new ByteArrayOutputStream();
        this.sffos = new SFFOutputStream(this.baos);
        this.mhos = new ModHuffmanOutputStream(this.sffos);
        this.rlos = new RLEBit1OutputStream(this.mhos);
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + "writeToSequence: Can only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        ColorModel colorModel = bufferedImage.getColorModel();
        if (bufferedImage.getType() != 12 || colorModel.getPixelSize() != 1) {
            throw new IOException(this.getClass().getName() + "writeToSequence:\n\tPlease convert image to black and white picture [TYPE_BYTE_BINARY,1 bps]");
        }
        try {
            int n = bufferedImage.getWidth();
            this.sffos.writePageHeader(n);
            this.writeBinaryImage(bufferedImage, n);
            this.sffos.writePageEnd();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".writeToSequence:\n\tCouldn't write data to SFF File." + exception.getMessage());
        }
    }

    private void writeBinaryImage(BufferedImage bufferedImage, int n) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n2 = bufferedImage.getHeight();
        int n3 = n / 8;
        int n4 = 7 - n % 8;
        int n5 = 0;
        if (n4 == 7) {
            for (int i = 0; i < n2; ++i) {
                this.rlos.setStartCodeWord(1);
                this.rlos.write(byArray, n5, n3);
                this.rlos.flush();
                this.mhos.writeEOL();
                n5 += n3;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.rlos.setStartCodeWord(1);
                this.rlos.write(byArray, n5, n3);
                this.rlos.writeBits(byArray[n5 + n3], 7, n4);
                this.rlos.flush();
                this.mhos.writeEOL();
                n5 += n3 + 1;
            }
        }
    }

    public void endWriteSequence() throws IOException {
        this.sffos.writeDocumentEnd();
        ((ImageOutputStream)this.getOutput()).write(this.baos.toByteArray());
    }
}

