/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.sff;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SFFOutputStream
extends BufferedOutputStream {
    private byte[] G3WhiteLineCode = new byte[]{-78, 89, 1};
    private byte[] buf = null;
    private boolean lastByteWasZero;
    private int index;
    private int width = 0;
    private int yres;
    private int whiteLines;

    public SFFOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeHeader();
        this.index = 0;
        this.lastByteWasZero = false;
        this.whiteLines = 0;
        this.yres = 196;
    }

    public void setXYResolution(int n, int n2) {
        this.yres = n2;
    }

    public void write(int n) throws IOException {
        this.buf[this.index++] = (byte)n;
        if (this.lastByteWasZero && (n & 0xFF) == 128) {
            this.writeLine(this.buf, this.index - 2);
            this.index = 0;
        }
        this.lastByteWasZero = n == 0;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    private void writeLine(byte[] byArray, int n) throws IOException {
        if (n > 0) {
            if (n <= 216) {
                this.out.write(n);
            } else {
                this.out.write(0);
                this.out.write(n & 0xFF);
                this.out.write(n >> 8 & 0xFF);
            }
            this.out.write(byArray, 0, n);
        }
    }

    private void writeWhiteLines() throws IOException {
        if (this.whiteLines > 0) {
            while (this.whiteLines > 37) {
                this.out.write(253);
                this.whiteLines -= 37;
            }
            this.out.write(216 + this.whiteLines);
            this.whiteLines = 0;
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(83);
        this.out.write(102);
        this.out.write(102);
        this.out.write(102);
        this.out.write(1);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(20);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
    }

    public void writePageHeader(int n) throws IOException {
        if (this.buf == null || this.buf.length != n) {
            this.buf = new byte[n];
        }
        this.width = n;
        this.out.write(254);
        this.out.write(16);
        this.out.write(this.yres == 98 ? 0 : 1);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.index = 0;
        this.lastByteWasZero = false;
    }

    public void writePageEnd() throws IOException {
        this.writeLine(this.buf, this.index);
    }

    public void writeDocumentEnd() throws IOException {
        this.out.write(254);
        this.out.write(0);
    }
}

