/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.tiff.DE;
import uk.co.mmscomputing.imageio.tiff.DEFactory;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;

class IFD
extends Vector
implements TIFFConstants {
    public long read(ImageInputStream imageInputStream, long l) throws IOException {
        imageInputStream.seek(l);
        int n = imageInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            this.add(DEFactory.read(imageInputStream));
        }
        return imageInputStream.readUnsignedInt();
    }

    public DE getDE(int n) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            DE dE = (DE)enumeration.nextElement();
            if (n != dE.getTag()) continue;
            return dE;
        }
        throw new IllegalArgumentException(this.getClass().getName() + "getIntValue:\n\tIFD does not feature DE with Tag " + n);
    }

    public long getIntValue(int n) {
        DE dE = this.getDE(n);
        if (dE.getCount() != 1L) {
            throw new IllegalArgumentException(this.getClass().getName() + "getIntValue:\n\tExpect Count=1 for Tag " + n);
        }
        return dE.getValue();
    }

    public int getNewSubfileType() {
        try {
            return (int)this.getIntValue(254);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DEFactory.NewSubfileTypeDE.getDefault();
        }
    }

    public int getWidth() {
        return (int)this.getIntValue(256);
    }

    public int getHeight() {
        return (int)this.getIntValue(257);
    }

    public int getLength() {
        return (int)this.getIntValue(257);
    }

    public int getBitsPerSample(int n) {
        try {
            return ((DEFactory.BitsPerSampleDE)this.getDE(258)).getBits(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 1;
        }
    }

    public long[] getBitsPerSample() {
        try {
            return ((DEFactory.BitsPerSampleDE)this.getDE(258)).getBits();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long[] lArray = new long[]{1L};
            return lArray;
        }
    }

    public int getCompression() {
        try {
            return (int)this.getIntValue(259);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 1;
        }
    }

    public int getPhotometricInterpretation() {
        try {
            return (int)this.getIntValue(262);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 1;
        }
    }

    public int getFillOrder() {
        try {
            return (int)this.getIntValue(266);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 1;
        }
    }

    public int getSamplesPerPixel() {
        try {
            return (int)this.getIntValue(277);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 1;
        }
    }

    public int getRowsPerStrip() {
        return (int)this.getIntValue(278);
    }

    public DEFactory.ColorMapDE getColorMap() {
        return (DEFactory.ColorMapDE)this.getDE(320);
    }

    public IndexColorModel getColorModel() {
        return ((DEFactory.ColorMapDE)this.getDE(320)).getColorModel();
    }

    public int getExtraSamplesLength() {
        try {
            return ((DEFactory.ExtraSamplesDE)this.getDE(338)).getExtraSamples().length;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
    }

    public int getExtraSample(int n) {
        return ((DEFactory.ExtraSamplesDE)this.getDE(338)).getExtraSample(n);
    }

    public int getSampleFormat() {
        try {
            return (int)this.getIntValue(339);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DEFactory.SampleFormatDE.getDefault();
        }
    }

    public byte[] getJPEGTables() {
        return ((DEFactory.JPEGTablesDE)this.getDE(347)).getData();
    }

    public int getT4Options() {
        try {
            return (int)this.getIntValue(292);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
    }

    public int getT6Options() {
        try {
            return (int)this.getIntValue(292);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
    }

    public int getPlanarConfiguration() {
        try {
            return (int)this.getIntValue(284);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 1;
        }
    }

    public int getResolutionUnit() {
        try {
            return (int)this.getIntValue(296);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 2;
        }
    }

    public long[] getStripOffsets() {
        return ((DEFactory.StripOffsetsDE)this.getDE(273)).getOffsets();
    }

    public long[] getStripByteCounts() {
        return ((DEFactory.StripByteCountsDE)this.getDE(279)).getCounts();
    }

    public int getPredictor() {
        try {
            return (int)this.getIntValue(317);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DEFactory.PredictorDE.getDefault();
        }
    }

    public double[] getYCbCrCoefficients() {
        try {
            return ((DEFactory.YCbCrCoefficientsDE)this.getDE(529)).getCoefficients();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            return dArray;
        }
    }

    public long[] getYCbCrSubSampling() {
        try {
            return ((DEFactory.YCbCrSubSamplingDE)this.getDE(530)).getSubSampling();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long[] lArray = new long[]{2L, 2L};
            return lArray;
        }
    }

    public int getYCbCrPositioning() {
        try {
            return (int)this.getIntValue(531);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 1;
        }
    }

    public double[] getReferenceBlackWhite() {
        try {
            return ((DEFactory.ReferenceBlackWhiteDE)this.getDE(532)).getReference();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long[] lArray = this.getBitsPerSample();
            double[] dArray = new double[]{0.0, (1 << (int)lArray[0]) - 1, 0.0, (1 << (int)lArray[1]) - 1, 0.0, (1 << (int)lArray[2]) - 1};
            return dArray;
        }
    }

    public long write(ImageOutputStream imageOutputStream, long l) throws IOException {
        DE dE;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            dE = (DE)enumeration.nextElement();
            dE.write(imageOutputStream);
        }
        long l2 = imageOutputStream.getStreamPosition();
        while (l2 % 4L != 0L) {
            imageOutputStream.write(0);
            ++l2;
        }
        imageOutputStream.mark();
        imageOutputStream.seek(l);
        imageOutputStream.writeInt((int)l2);
        imageOutputStream.reset();
        int n = this.size();
        imageOutputStream.writeShort(n);
        enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            dE = (DE)enumeration.nextElement();
            dE.writeEntry(imageOutputStream);
        }
        l2 = imageOutputStream.getStreamPosition();
        imageOutputStream.writeInt(0);
        return l2;
    }
}

