/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;
import uk.co.mmscomputing.io.BitSwapTable;

public class TIFFClassBOutputStream
extends FilterOutputStream
implements TIFFConstants,
BitSwapTable {
    private ByteArrayOutputStream buf = null;
    private boolean lastByteWasZero;
    private int width;
    private int height;
    private int offset;

    public TIFFClassBOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeHeader();
    }

    public void write(int n) throws IOException {
        if (this.lastByteWasZero) {
            if ((n & 0xFF) == 128) {
                this.lastByteWasZero = false;
                ++this.height;
                return;
            }
            this.buf.write(0);
        }
        if (n == 0) {
            this.lastByteWasZero = true;
        } else {
            this.lastByteWasZero = false;
            this.buf.write(bitSwapTable[n & 0xFF]);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    public void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    public void writeInt(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n >> 16 & 0xFF);
        this.out.write(n >> 24 & 0xFF);
    }

    private void writeHeader() throws IOException {
        this.writeShort(18761);
        this.writeShort(42);
        this.offset = 8;
    }

    public void writePageHeader(int n) throws IOException {
        this.buf = new ByteArrayOutputStream();
        this.width = n;
        this.height = 0;
        this.lastByteWasZero = false;
    }

    public void writePageEnd() throws IOException {
        if (this.lastByteWasZero) {
            this.buf.write(0);
        }
        int n = this.buf.size() & 1;
        byte[] byArray = this.buf.toByteArray();
        int n2 = this.offset + byArray.length + n + 16;
        this.writeInt(n2);
        this.out.write(byArray);
        if (n > 0) {
            this.out.write(0);
        }
        this.writeInt(203);
        this.writeInt(1);
        this.writeInt(196);
        this.writeInt(1);
        this.writeShort(10);
        this.writeShort(256);
        this.writeShort(4);
        this.writeInt(1);
        this.writeInt(this.width);
        this.writeShort(257);
        this.writeShort(4);
        this.writeInt(1);
        this.writeInt(this.height);
        this.writeShort(259);
        this.writeShort(3);
        this.writeInt(1);
        this.writeInt(2);
        this.writeShort(262);
        this.writeShort(3);
        this.writeInt(1);
        this.writeInt(0);
        this.writeShort(273);
        this.writeShort(4);
        this.writeInt(1);
        this.writeInt(this.offset);
        this.writeShort(278);
        this.writeShort(4);
        this.writeInt(1);
        this.writeInt(this.height);
        this.writeShort(279);
        this.writeShort(4);
        this.writeInt(1);
        this.writeInt(byArray.length);
        this.writeShort(282);
        this.writeShort(5);
        this.writeInt(1);
        this.writeInt(n2 - 16);
        this.writeShort(283);
        this.writeShort(5);
        this.writeInt(1);
        this.writeInt(n2 - 8);
        this.writeShort(296);
        this.writeShort(3);
        this.writeInt(1);
        this.writeInt(2);
        this.offset = n2 + 126;
    }

    public void writeDocumentEnd() throws IOException {
        this.writeInt(0);
    }
}

