/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import javax.imageio.IIOParam;
import javax.imageio.IIOParamController;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;
import uk.co.mmscomputing.imageio.tiff.TIFFImageWriteParam;

public class TIFFIIOParamController
extends JPanel
implements ActionListener,
ChangeListener,
IIOParamController,
TIFFConstants {
    private JDialog dialog;
    private Semaphore blocker = new Semaphore(0, true);
    private boolean cancelled = false;
    private JRadioButton buttonBW;
    private JRadioButton buttonGray;
    private JRadioButton buttonRGB;
    private JRadioButton buttonCMYK;
    private JRadioButton buttonYCbCr;
    private JRadioButton buttonNONE;
    private JRadioButton buttonMH;
    private JRadioButton buttonT4MH;
    private JRadioButton buttonT4MR;
    private JRadioButton buttonT6MMR;
    private JRadioButton buttonJPEG;
    private JRadioButton buttonSS111;
    private JRadioButton buttonSS211;
    private JSlider sliderQuality;
    private static String pi = "WHITEISZERO";
    private static String compression = "t6mmr";
    private static int quality = 50;
    private static int subsampling = 34;

    public TIFFIIOParamController(Locale locale) {
        super(new BorderLayout());
        this.add((Component)this.getMainCentralPanel(), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("ok");
        jButton.setActionCommand("ok");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
        this.init(pi, compression, subsampling);
    }

    private void init(String string, String string2, int n) {
        this.setCompression(string2);
        this.setPhotometricInterpretation(string);
        switch (n) {
            case 17: {
                this.setSubSampling("1:1:1");
                break;
            }
            default: {
                this.setSubSampling("2:1:1");
            }
        }
    }

    private JPanel getMainCentralPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(new EtchedBorder());
        jPanel.add(this.getPhotometricInterpretationPanel());
        jPanel.add(this.getCompressionPanel());
        jPanel.add(this.getQualityPanel());
        jPanel.add(this.getSubSamplingPanel());
        return jPanel;
    }

    private JPanel getPhotometricInterpretationPanel() {
        this.buttonBW = new JRadioButton("Black/White");
        this.buttonBW.setActionCommand("WHITEISZERO");
        this.buttonBW.addActionListener(this);
        this.buttonGray = new JRadioButton("BlackIsZero (Gray)");
        this.buttonGray.setActionCommand("BLACKISZERO");
        this.buttonGray.addActionListener(this);
        this.buttonRGB = new JRadioButton("RGB");
        this.buttonRGB.setActionCommand("RGB");
        this.buttonRGB.addActionListener(this);
        this.buttonCMYK = new JRadioButton("CMYK");
        this.buttonCMYK.setActionCommand("CMYK");
        this.buttonCMYK.addActionListener(this);
        this.buttonYCbCr = new JRadioButton("YCbCr");
        this.buttonYCbCr.setActionCommand("YCbCr");
        this.buttonYCbCr.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttonBW);
        buttonGroup.add(this.buttonGray);
        buttonGroup.add(this.buttonRGB);
        buttonGroup.add(this.buttonCMYK);
        buttonGroup.add(this.buttonYCbCr);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Photometric Interpretation"));
        jPanel.add(this.buttonBW);
        jPanel.add(this.buttonGray);
        jPanel.add(this.buttonRGB);
        jPanel.add(this.buttonCMYK);
        jPanel.add(this.buttonYCbCr);
        return jPanel;
    }

    private JPanel getCompressionPanel() {
        this.buttonNONE = new JRadioButton("None");
        this.buttonNONE.setActionCommand("none");
        this.buttonNONE.addActionListener(this);
        this.buttonMH = new JRadioButton("BL MH");
        this.buttonMH.setActionCommand("mh");
        this.buttonMH.addActionListener(this);
        this.buttonT4MH = new JRadioButton("T4 MH");
        this.buttonT4MH.setActionCommand("t4mh");
        this.buttonT4MH.addActionListener(this);
        this.buttonT4MR = new JRadioButton("T4 MR");
        this.buttonT4MR.setActionCommand("t4mr");
        this.buttonT4MR.addActionListener(this);
        this.buttonT6MMR = new JRadioButton("T6 MMR");
        this.buttonT6MMR.setActionCommand("t6mmr");
        this.buttonT6MMR.addActionListener(this);
        this.buttonJPEG = new JRadioButton("JPEG");
        this.buttonJPEG.setActionCommand("jpeg");
        this.buttonJPEG.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttonNONE);
        buttonGroup.add(this.buttonMH);
        buttonGroup.add(this.buttonT4MH);
        buttonGroup.add(this.buttonT4MR);
        buttonGroup.add(this.buttonT6MMR);
        buttonGroup.add(this.buttonJPEG);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Compression"));
        jPanel.add(this.buttonNONE);
        jPanel.add(this.buttonMH);
        jPanel.add(this.buttonT4MH);
        jPanel.add(this.buttonT4MR);
        jPanel.add(this.buttonT6MMR);
        jPanel.add(this.buttonJPEG);
        return jPanel;
    }

    private JPanel getSubSamplingPanel() {
        this.buttonSS111 = new JRadioButton("1:1:1");
        this.buttonSS111.setActionCommand("1:1:1");
        this.buttonSS111.addActionListener(this);
        this.buttonSS211 = new JRadioButton("2:1:1");
        this.buttonSS211.setActionCommand("2:1:1");
        this.buttonSS211.addActionListener(this);
        this.buttonSS111.setEnabled(false);
        this.buttonSS211.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttonSS111);
        buttonGroup.add(this.buttonSS211);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Y-Cb-Cr Sub Sampling"));
        jPanel.add(this.buttonSS111);
        jPanel.add(this.buttonSS211);
        return jPanel;
    }

    private boolean setPhotometricInterpretation(String string) {
        if (string.equals("WHITEISZERO")) {
            pi = "WHITEISZERO";
            this.buttonBW.setSelected(true);
            this.buttonNONE.setEnabled(false);
            this.buttonMH.setEnabled(true);
            this.buttonT4MH.setEnabled(true);
            this.buttonT4MR.setEnabled(true);
            this.buttonT6MMR.setEnabled(true);
            this.buttonJPEG.setEnabled(false);
            if (this.buttonNONE.isSelected() || this.buttonJPEG.isSelected()) {
                this.setCompression("t6mmr");
            }
            this.buttonSS111.setEnabled(false);
            this.buttonSS211.setEnabled(false);
        } else if (string.equals("BLACKISZERO")) {
            pi = "BLACKISZERO";
            this.buttonGray.setSelected(true);
            this.buttonNONE.setEnabled(true);
            this.buttonMH.setEnabled(false);
            this.buttonT4MH.setEnabled(false);
            this.buttonT4MR.setEnabled(false);
            this.buttonT6MMR.setEnabled(false);
            this.buttonJPEG.setEnabled(true);
            if (!this.buttonNONE.isSelected() && !this.buttonJPEG.isSelected()) {
                this.setCompression("none");
            }
            this.buttonSS111.setEnabled(false);
            this.buttonSS211.setEnabled(false);
        } else if (string.equals("RGB")) {
            pi = "RGB";
            this.buttonRGB.setSelected(true);
            this.buttonNONE.setEnabled(true);
            this.buttonMH.setEnabled(false);
            this.buttonT4MH.setEnabled(false);
            this.buttonT4MR.setEnabled(false);
            this.buttonT6MMR.setEnabled(false);
            this.buttonJPEG.setEnabled(true);
            if (!this.buttonNONE.isSelected() && !this.buttonJPEG.isSelected()) {
                this.setCompression("none");
            }
            this.buttonSS111.setEnabled(false);
            this.buttonSS211.setEnabled(false);
        } else if (string.equals("CMYK")) {
            pi = "CMYK";
            this.buttonCMYK.setSelected(true);
            this.buttonNONE.setEnabled(true);
            this.buttonMH.setEnabled(false);
            this.buttonT4MH.setEnabled(false);
            this.buttonT4MR.setEnabled(false);
            this.buttonT6MMR.setEnabled(false);
            this.buttonJPEG.setEnabled(false);
            if (!this.buttonNONE.isSelected()) {
                this.setCompression("none");
            }
            this.buttonSS111.setEnabled(false);
            this.buttonSS211.setEnabled(false);
        } else if (string.equals("YCbCr")) {
            pi = "YCbCr";
            this.buttonYCbCr.setSelected(true);
            this.buttonNONE.setEnabled(true);
            this.buttonMH.setEnabled(false);
            this.buttonT4MH.setEnabled(false);
            this.buttonT4MR.setEnabled(false);
            this.buttonT6MMR.setEnabled(false);
            this.buttonJPEG.setEnabled(true);
            if (!this.buttonNONE.isSelected() && !this.buttonJPEG.isSelected()) {
                this.setCompression("none");
            }
            this.buttonSS111.setEnabled(true);
            this.buttonSS211.setEnabled(true);
        } else {
            return false;
        }
        return true;
    }

    private boolean setCompression(String string) {
        if (string.startsWith("none")) {
            compression = string;
            int n = quality;
            this.sliderQuality.setValue(100);
            quality = n;
            this.sliderQuality.setEnabled(false);
            this.buttonNONE.setSelected(true);
        } else if (string.startsWith("mh")) {
            compression = string;
            int n = quality;
            this.sliderQuality.setValue(100);
            quality = n;
            this.sliderQuality.setEnabled(false);
            this.buttonMH.setSelected(true);
        } else if (string.startsWith("t4mh")) {
            compression = string;
            int n = quality;
            this.sliderQuality.setValue(100);
            quality = n;
            this.sliderQuality.setEnabled(false);
            this.buttonT4MH.setSelected(true);
        } else if (string.startsWith("t4mr")) {
            compression = string;
            int n = quality;
            this.sliderQuality.setValue(100);
            quality = n;
            this.sliderQuality.setEnabled(false);
            this.buttonT4MR.setSelected(true);
        } else if (string.startsWith("t6mmr")) {
            compression = string;
            int n = quality;
            this.sliderQuality.setValue(100);
            quality = n;
            this.sliderQuality.setEnabled(false);
            this.buttonT6MMR.setSelected(true);
        } else if (string.startsWith("jpeg")) {
            compression = string;
            this.sliderQuality.setValue(quality);
            this.sliderQuality.setEnabled(true);
            this.buttonJPEG.setSelected(true);
        } else {
            return false;
        }
        return true;
    }

    private boolean setSubSampling(String string) {
        if (string.equals("1:1:1")) {
            this.buttonSS111.setSelected(true);
            subsampling = 17;
        } else if (string.equals("2:1:1")) {
            this.buttonSS211.setSelected(true);
            subsampling = 34;
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.cancelled = false;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.blocker.release();
        } else if (string.equals("cancel")) {
            this.cancelled = true;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.blocker.release();
        } else if (this.setPhotometricInterpretation(string) || this.setCompression(string) || this.setSubSampling(string)) {
            // empty if block
        }
    }

    private JPanel getQualityPanel() {
        this.sliderQuality = new JSlider(0, 0, 100, quality);
        this.sliderQuality.addChangeListener(this);
        this.sliderQuality.setEnabled(false);
        this.sliderQuality.setMinorTickSpacing(2);
        this.sliderQuality.setMajorTickSpacing(10);
        this.sliderQuality.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 100; i += 10) {
            ((Dictionary)hashtable).put(new Integer(i), new JLabel(Integer.toString(i)));
        }
        this.sliderQuality.setLabelTable(hashtable);
        this.sliderQuality.setPaintLabels(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "JPEG Quality"));
        jPanel.add((Component)this.sliderQuality, "Center");
        return jPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting() && jSlider == this.sliderQuality && (quality = jSlider.getValue()) <= 0) {
            quality = 1;
            jSlider.setValue(1);
        }
    }

    public void display() {
        try {
            this.dialog = new JDialog((Frame)null, "TIFF Write Parameter Settings", false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(null);
            this.dialog.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".display:\n\t" + exception);
            exception.printStackTrace();
        }
    }

    public boolean activate(IIOParam iIOParam) {
        this.display();
        try {
            this.blocker.acquire();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.cancelled) {
            return false;
        }
        TIFFImageWriteParam tIFFImageWriteParam = (TIFFImageWriteParam)iIOParam;
        tIFFImageWriteParam.setCompressionType(compression);
        tIFFImageWriteParam.setPhotometricInterpretation(pi);
        tIFFImageWriteParam.setCompressionQuality((float)quality / 100.0f);
        tIFFImageWriteParam.setSubSampling(subsampling);
        return true;
    }
}

