/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import uk.co.mmscomputing.imageio.jpeg.JPEGConstants;
import uk.co.mmscomputing.imageio.jpeg.JPEGOutputStream;
import uk.co.mmscomputing.imageio.tiff.DEFactory;
import uk.co.mmscomputing.imageio.tiff.IFD;
import uk.co.mmscomputing.imageio.tiff.TIFFClassFFactory;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;
import uk.co.mmscomputing.imageio.tiff.TIFFImageWriteParam;
import uk.co.mmscomputing.imageio.tiff.TIFFSubSamplingOutputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFYCbCrOutputStream;
import uk.co.mmscomputing.io.BitSwapOutputStream;
import uk.co.mmscomputing.io.ModHuffmanOutputStream;
import uk.co.mmscomputing.io.RLEOutputStream;

public class TIFFImageWriter
extends ImageWriter
implements TIFFConstants {
    private long ifdptr = 0L;

    protected TIFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new TIFFImageWriteParam(this.getLocale());
    }

    public boolean canInsertImage(int n) throws IOException {
        return n == 0;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.prepareWriteSequence(iIOMetadata);
        this.writeToSequence(iIOImage, imageWriteParam);
        this.endWriteSequence();
    }

    public boolean canWriteSequence() {
        return true;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        imageOutputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        imageOutputStream.writeShort(18761);
        imageOutputStream.writeShort(42);
        this.ifdptr = imageOutputStream.getStreamPosition();
        imageOutputStream.writeInt(0);
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        IFD iFD;
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
        if (!(iIOImage.getRenderedImage() instanceof BufferedImage)) {
            throw new IOException(this.getClass().getName() + "writeToSequence:\n\tCan only write BufferedImage objects");
        }
        BufferedImage bufferedImage = (BufferedImage)iIOImage.getRenderedImage();
        int n = 2;
        int n2 = 0;
        int n3 = 1;
        TIFFImageWriteParam tIFFImageWriteParam = null;
        if (imageWriteParam != null && imageWriteParam instanceof TIFFImageWriteParam) {
            tIFFImageWriteParam = (TIFFImageWriteParam)imageWriteParam;
            n = tIFFImageWriteParam.getPhotometricInterpretation();
            if (tIFFImageWriteParam.getCompressionType().equals("none")) {
                n2 = 0;
                n3 = 1;
            } else if (tIFFImageWriteParam.getCompressionType().equals("mh")) {
                n2 = 1;
                n3 = 2;
            } else if (tIFFImageWriteParam.getCompressionType().equals("t4mh")) {
                n2 = 2;
                n3 = 3;
            } else if (tIFFImageWriteParam.getCompressionType().equals("t4mr")) {
                n2 = 3;
                n3 = 3;
            } else if (tIFFImageWriteParam.getCompressionType().equals("t6mmr")) {
                n2 = 4;
                n3 = 4;
            } else if (tIFFImageWriteParam.getCompressionType().equals("packbits")) {
                n2 = 5;
                n3 = 32773;
            } else if (tIFFImageWriteParam.getCompressionType().equals("lzw")) {
                n2 = 6;
                n3 = 5;
            } else if (tIFFImageWriteParam.getCompressionType().equals("jpeg")) {
                n2 = 7;
                n3 = 7;
            }
        }
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 1: {
                        iFD = this.writeBModHufImage(imageOutputStream, bufferedImage, tIFFImageWriteParam);
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        iFD = TIFFClassFFactory.writeImage(imageOutputStream, bufferedImage, n2, tIFFImageWriteParam);
                        break block0;
                    }
                }
                iFD = this.writeRGBImage(imageOutputStream, bufferedImage, 1, tIFFImageWriteParam);
                break;
            }
            case 1: {
                switch (n2) {
                    default: 
                }
                iFD = this.writeGrayImage(imageOutputStream, bufferedImage, n3, tIFFImageWriteParam);
                break;
            }
            case 2: {
                switch (n2) {
                    default: 
                }
                iFD = this.writeRGBImage(imageOutputStream, bufferedImage, n3, tIFFImageWriteParam);
                break;
            }
            case 5: {
                switch (n2) {
                    default: 
                }
                iFD = this.writeCMYKImage(imageOutputStream, bufferedImage, tIFFImageWriteParam);
                break;
            }
            case 6: {
                switch (n2) {
                    default: 
                }
                iFD = this.writeYCbCrImage(imageOutputStream, bufferedImage, n3, tIFFImageWriteParam);
                break;
            }
            default: {
                iFD = this.writeRGBImage(imageOutputStream, bufferedImage, 1, tIFFImageWriteParam);
            }
        }
        this.ifdptr = iFD.write(imageOutputStream, this.ifdptr);
    }

    public void endWriteSequence() throws IOException {
        ImageOutputStream imageOutputStream = (ImageOutputStream)this.getOutput();
    }

    private IFD writeBModHufImage(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, TIFFImageWriteParam tIFFImageWriteParam) throws IOException {
        try {
            int n;
            int n2;
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            IFD iFD = new IFD();
            iFD.add(new DEFactory.NewSubfileTypeDE(2));
            iFD.add(new DEFactory.ImageWidthDE(n3));
            iFD.add(new DEFactory.ImageLengthDE(n4));
            iFD.add(new DEFactory.CompressionDE(2));
            iFD.add(new DEFactory.PhotometricInterpretationDE(0));
            if (8192 <= n3) {
                n2 = 1;
                n = n4;
            } else {
                n2 = 8192 / n3;
                n = (n4 + n2 - 1) / n2;
            }
            DEFactory.StripOffsetsDE stripOffsetsDE = new DEFactory.StripOffsetsDE(n);
            iFD.add(stripOffsetsDE);
            iFD.add(new DEFactory.RowsPerStripDE(n2));
            DEFactory.StripByteCountsDE stripByteCountsDE = new DEFactory.StripByteCountsDE(n);
            iFD.add(stripByteCountsDE);
            if (tIFFImageWriteParam == null) {
                iFD.add(new DEFactory.XResolutionDE(72.0));
                iFD.add(new DEFactory.YResolutionDE(72.0));
            } else {
                iFD.add(new DEFactory.XResolutionDE(tIFFImageWriteParam.getXResolution()));
                iFD.add(new DEFactory.YResolutionDE(tIFFImageWriteParam.getYResolution()));
            }
            iFD.add(new DEFactory.ResolutionUnitDE(2));
            int n5 = 0;
            for (int i = 0; i < n4; i += n2) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BitSwapOutputStream bitSwapOutputStream = new BitSwapOutputStream(byteArrayOutputStream);
                ModHuffmanOutputStream modHuffmanOutputStream = new ModHuffmanOutputStream(bitSwapOutputStream);
                RLEOutputStream rLEOutputStream = new RLEOutputStream(modHuffmanOutputStream, 3);
                for (int j = 0; j < n2 && i + j != n4; ++j) {
                    rLEOutputStream.setStartCodeWord(-1);
                    for (int k = 0; k < n3; ++k) {
                        rLEOutputStream.write(bufferedImage.getRGB(k, i + j));
                    }
                    rLEOutputStream.flush();
                }
                rLEOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                stripByteCountsDE.setCount(n5, byArray.length);
                stripOffsetsDE.setOffset(n5, imageOutputStream.getStreamPosition());
                imageOutputStream.write(byArray);
                ++n5;
            }
            return iFD;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".writeBModHufImage:\n\t" + exception.getMessage());
        }
    }

    private IFD writeGrayImage(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, int n, TIFFImageWriteParam tIFFImageWriteParam) throws IOException {
        bufferedImage = this.convert(bufferedImage, 10);
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream;
            int n2;
            int n3;
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            IFD iFD = new IFD();
            iFD.add(new DEFactory.NewSubfileTypeDE(2));
            iFD.add(new DEFactory.ImageWidthDE(n4));
            iFD.add(new DEFactory.ImageLengthDE(n5));
            DEFactory.BitsPerSampleDE bitsPerSampleDE = new DEFactory.BitsPerSampleDE(1);
            bitsPerSampleDE.setBitsPerSample(0, 8L);
            iFD.add(bitsPerSampleDE);
            iFD.add(new DEFactory.CompressionDE(n));
            iFD.add(new DEFactory.PhotometricInterpretationDE(1));
            if (8192 <= n4) {
                n3 = 1;
                n2 = n5;
            } else {
                n3 = 8192 / n4;
                n2 = (n5 + n3 - 1) / n3;
            }
            if (n == 7) {
                n3 = (n3 + 8 - 1) / 8 * 8;
                n2 = (n5 + n3 - 1) / n3;
            }
            DEFactory.StripOffsetsDE stripOffsetsDE = new DEFactory.StripOffsetsDE(n2);
            iFD.add(stripOffsetsDE);
            iFD.add(new DEFactory.SamplesPerPixelDE(1));
            iFD.add(new DEFactory.RowsPerStripDE(n3));
            DEFactory.StripByteCountsDE stripByteCountsDE = new DEFactory.StripByteCountsDE(n2);
            iFD.add(stripByteCountsDE);
            if (tIFFImageWriteParam == null) {
                iFD.add(new DEFactory.XResolutionDE(72.0));
                iFD.add(new DEFactory.YResolutionDE(72.0));
            } else {
                iFD.add(new DEFactory.XResolutionDE(tIFFImageWriteParam.getXResolution()));
                iFD.add(new DEFactory.YResolutionDE(tIFFImageWriteParam.getYResolution()));
            }
            iFD.add(new DEFactory.ResolutionUnitDE(2));
            OutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
            JPEGOutputStream jPEGOutputStream = null;
            if (n == 7) {
                jPEGOutputStream = new JPEGOutputStream(byteArrayOutputStream);
                int n6 = tIFFImageWriteParam == null ? 50 : (int)(tIFFImageWriteParam.getCompressionQuality() * 100.0f);
                jPEGOutputStream.setZZQuantizationTable(0, JPEGConstants.LQT, n6);
                jPEGOutputStream.setRawDCHuffmanTable(0, JPEGConstants.HLDCTable);
                jPEGOutputStream.setRawACHuffmanTable(0, JPEGConstants.HLACTable);
                jPEGOutputStream.defineQuantizationTables();
                jPEGOutputStream.defineHuffmanTables();
                jPEGOutputStream.close();
                object = new DEFactory.JPEGTablesDE(byteArrayOutputStream.toByteArray());
                iFD.add(object);
                byteArrayOutputStream.reset();
                outputStream = jPEGOutputStream;
            }
            WritableRaster writableRaster = bufferedImage.getRaster();
            object = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = ((DataBufferByte)object).getData();
            int n7 = 0;
            for (int i = 0; i < n5; i += n3) {
                Object[] objectArray;
                if (n5 - i < n3) {
                    n3 = n5 - i;
                }
                if (jPEGOutputStream != null) {
                    jPEGOutputStream.startOfImage();
                    objectArray = new int[]{17};
                    int[] nArray = new int[]{0};
                    jPEGOutputStream.startOfFrame(n3, n4, (int[])objectArray, nArray);
                    int[] nArray2 = new int[]{0};
                    jPEGOutputStream.startOfScan(nArray2);
                }
                ((OutputStream)outputStream).write(byArray, i * n4, n3 * n4);
                ((OutputStream)outputStream).close();
                objectArray = byteArrayOutputStream.toByteArray();
                stripByteCountsDE.setCount(n7, objectArray.length);
                stripOffsetsDE.setOffset(n7, imageOutputStream.getStreamPosition());
                imageOutputStream.write((byte[])objectArray);
                byteArrayOutputStream.reset();
                ++n7;
            }
            return iFD;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".writeRGBImage:\n\t" + exception.getMessage());
        }
    }

    private IFD writeRGBImage(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, int n, TIFFImageWriteParam tIFFImageWriteParam) throws IOException {
        bufferedImage = this.convert(bufferedImage, 1);
        try {
            Object object;
            int n2;
            int n3;
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            IFD iFD = new IFD();
            iFD.add(new DEFactory.NewSubfileTypeDE(2));
            iFD.add(new DEFactory.ImageWidthDE(n4));
            iFD.add(new DEFactory.ImageLengthDE(n5));
            DEFactory.BitsPerSampleDE bitsPerSampleDE = new DEFactory.BitsPerSampleDE(3);
            bitsPerSampleDE.setBitsPerSample(0, 8L);
            bitsPerSampleDE.setBitsPerSample(1, 8L);
            bitsPerSampleDE.setBitsPerSample(2, 8L);
            iFD.add(bitsPerSampleDE);
            iFD.add(new DEFactory.CompressionDE(n));
            iFD.add(new DEFactory.PhotometricInterpretationDE(2));
            if (8192 <= n4) {
                n3 = 1;
                n2 = n5;
            } else {
                n3 = 8192 / n4;
                n2 = (n5 + n3 - 1) / n3;
            }
            if (n == 7) {
                n3 = (n3 + 8 - 1) / 8 * 8;
                n2 = (n5 + n3 - 1) / n3;
            }
            DEFactory.StripOffsetsDE stripOffsetsDE = new DEFactory.StripOffsetsDE(n2);
            iFD.add(stripOffsetsDE);
            iFD.add(new DEFactory.SamplesPerPixelDE(3));
            iFD.add(new DEFactory.RowsPerStripDE(n3));
            DEFactory.StripByteCountsDE stripByteCountsDE = new DEFactory.StripByteCountsDE(n2);
            iFD.add(stripByteCountsDE);
            if (tIFFImageWriteParam == null) {
                iFD.add(new DEFactory.XResolutionDE(72.0));
                iFD.add(new DEFactory.YResolutionDE(72.0));
            } else {
                iFD.add(new DEFactory.XResolutionDE(tIFFImageWriteParam.getXResolution()));
                iFD.add(new DEFactory.YResolutionDE(tIFFImageWriteParam.getYResolution()));
            }
            iFD.add(new DEFactory.ResolutionUnitDE(2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = byteArrayOutputStream;
            JPEGOutputStream jPEGOutputStream = null;
            if (n == 7) {
                jPEGOutputStream = new JPEGOutputStream(byteArrayOutputStream);
                int n6 = tIFFImageWriteParam == null ? 50 : (int)(tIFFImageWriteParam.getCompressionQuality() * 100.0f);
                jPEGOutputStream.setZZQuantizationTable(0, JPEGConstants.LQT, n6);
                jPEGOutputStream.setRawDCHuffmanTable(0, JPEGConstants.HLDCTable);
                jPEGOutputStream.setRawACHuffmanTable(0, JPEGConstants.HLACTable);
                jPEGOutputStream.defineQuantizationTables();
                jPEGOutputStream.defineHuffmanTables();
                jPEGOutputStream.close();
                object = new DEFactory.JPEGTablesDE(byteArrayOutputStream.toByteArray());
                iFD.add(object);
                byteArrayOutputStream.reset();
                outputStream = jPEGOutputStream;
            }
            WritableRaster writableRaster = bufferedImage.getRaster();
            object = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = ((DataBufferInt)object).getData();
            int n7 = 0;
            for (int i = 0; i < n5; i += n3) {
                Object[] objectArray;
                if (n5 - i < n3) {
                    n3 = n5 - i;
                }
                if (jPEGOutputStream != null) {
                    jPEGOutputStream.startOfImage();
                    objectArray = new int[]{17, 17, 17};
                    int[] nArray2 = new int[]{0, 0, 0};
                    jPEGOutputStream.startOfFrame(n3, n4, (int[])objectArray, nArray2);
                    int[] nArray3 = new int[]{0, 0, 0};
                    jPEGOutputStream.startOfScan(nArray3);
                }
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        int n8 = nArray[k + (i + j) * n4];
                        outputStream.write(n8 >> 16 & 0xFF);
                        outputStream.write(n8 >> 8 & 0xFF);
                        outputStream.write(n8 & 0xFF);
                    }
                }
                outputStream.close();
                objectArray = byteArrayOutputStream.toByteArray();
                stripByteCountsDE.setCount(n7, objectArray.length);
                stripOffsetsDE.setOffset(n7, imageOutputStream.getStreamPosition());
                imageOutputStream.write((byte[])objectArray);
                byteArrayOutputStream.reset();
                ++n7;
            }
            return iFD;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".writeRGBImage:\n\t" + exception.getMessage());
        }
    }

    private IFD writeCMYKImage(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, TIFFImageWriteParam tIFFImageWriteParam) throws IOException {
        try {
            int n;
            int n2;
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            IFD iFD = new IFD();
            iFD.add(new DEFactory.NewSubfileTypeDE(2));
            iFD.add(new DEFactory.ImageWidthDE(n3));
            iFD.add(new DEFactory.ImageLengthDE(n4));
            DEFactory.BitsPerSampleDE bitsPerSampleDE = new DEFactory.BitsPerSampleDE(4);
            bitsPerSampleDE.setBitsPerSample(0, 8L);
            bitsPerSampleDE.setBitsPerSample(1, 8L);
            bitsPerSampleDE.setBitsPerSample(2, 8L);
            bitsPerSampleDE.setBitsPerSample(3, 8L);
            iFD.add(bitsPerSampleDE);
            iFD.add(new DEFactory.CompressionDE(1));
            iFD.add(new DEFactory.PhotometricInterpretationDE(5));
            if (8192 <= n3) {
                n2 = 1;
                n = n4;
            } else {
                n2 = 8192 / n3;
                n = (n4 + n2 - 1) / n2;
            }
            DEFactory.StripOffsetsDE stripOffsetsDE = new DEFactory.StripOffsetsDE(n);
            iFD.add(stripOffsetsDE);
            iFD.add(new DEFactory.SamplesPerPixelDE(4));
            iFD.add(new DEFactory.RowsPerStripDE(n2));
            DEFactory.StripByteCountsDE stripByteCountsDE = new DEFactory.StripByteCountsDE(n);
            iFD.add(stripByteCountsDE);
            if (tIFFImageWriteParam == null) {
                iFD.add(new DEFactory.XResolutionDE(72.0));
                iFD.add(new DEFactory.YResolutionDE(72.0));
            } else {
                iFD.add(new DEFactory.XResolutionDE(tIFFImageWriteParam.getXResolution()));
                iFD.add(new DEFactory.YResolutionDE(tIFFImageWriteParam.getYResolution()));
            }
            iFD.add(new DEFactory.ResolutionUnitDE(2));
            int n5 = 0;
            for (int i = 0; i < n4; i += n2) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int j = 0; j < n2 && i + j != n4; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        int n6 = bufferedImage.getRGB(k, i + j);
                        int n7 = n6 >> 16 & 0xFF;
                        int n8 = n6 >> 8 & 0xFF;
                        int n9 = n6 & 0xFF;
                        if (n7 == 255 && n8 == 255 && n9 == 255) {
                            byteArrayOutputStream.write(0);
                            byteArrayOutputStream.write(0);
                            byteArrayOutputStream.write(0);
                            byteArrayOutputStream.write(0);
                            continue;
                        }
                        double d = 1.0 - (double)n7 / 255.0;
                        double d2 = 1.0 - (double)n8 / 255.0;
                        double d3 = 1.0 - (double)n9 / 255.0;
                        double d4 = d;
                        if (d2 < d4) {
                            d4 = d2;
                        }
                        if (d3 < d4) {
                            d4 = d3;
                        }
                        d = (d - d4) / (1.0 - d4) * 255.0;
                        d2 = (d2 - d4) / (1.0 - d4) * 255.0;
                        d3 = (d3 - d4) / (1.0 - d4) * 255.0;
                        byteArrayOutputStream.write((int)d);
                        byteArrayOutputStream.write((int)d2);
                        byteArrayOutputStream.write((int)d3);
                        byteArrayOutputStream.write((int)(d4 *= 255.0));
                    }
                }
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                stripByteCountsDE.setCount(n5, byArray.length);
                stripOffsetsDE.setOffset(n5, imageOutputStream.getStreamPosition());
                imageOutputStream.write(byArray);
                ++n5;
            }
            return iFD;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".writeCMYKImage:\n\t" + exception.getMessage());
        }
    }

    private IFD writeYCbCrImage(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, int n, TIFFImageWriteParam tIFFImageWriteParam) throws IOException {
        bufferedImage = this.convert(bufferedImage, 1);
        try {
            TIFFYCbCrOutputStream tIFFYCbCrOutputStream;
            int n2;
            int n3;
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            IFD iFD = new IFD();
            int n6 = tIFFImageWriteParam == null ? 34 : tIFFImageWriteParam.getSubSampling();
            int n7 = n6 >> 4 & 0xF;
            int n8 = n6 & 0xF;
            if (n7 < n8) {
                throw new IOException("Internal error: YCbCrSubsampleVert is not less than YCbCrSubsampleHoriz.");
            }
            int n9 = n4;
            int n10 = n5;
            iFD.add(new DEFactory.NewSubfileTypeDE(2));
            iFD.add(new DEFactory.ImageWidthDE(n9));
            iFD.add(new DEFactory.ImageLengthDE(n10));
            DEFactory.BitsPerSampleDE bitsPerSampleDE = new DEFactory.BitsPerSampleDE(3);
            bitsPerSampleDE.setBitsPerSample(0, 8L);
            bitsPerSampleDE.setBitsPerSample(1, 8L);
            bitsPerSampleDE.setBitsPerSample(2, 8L);
            iFD.add(bitsPerSampleDE);
            iFD.add(new DEFactory.CompressionDE(n));
            iFD.add(new DEFactory.PhotometricInterpretationDE(6));
            if (8192 <= n4) {
                n3 = 1;
                n2 = n5;
            } else {
                n3 = 8192 / n4;
                n2 = (n5 + n3 - 1) / n3;
            }
            if (n == 7) {
                n3 = (n3 + 8 * n8 - 1) / (8 * n8) * (8 * n8);
                n2 = (n5 + n3 - 1) / n3;
            }
            DEFactory.StripOffsetsDE stripOffsetsDE = new DEFactory.StripOffsetsDE(n2);
            iFD.add(stripOffsetsDE);
            iFD.add(new DEFactory.SamplesPerPixelDE(3));
            iFD.add(new DEFactory.RowsPerStripDE(n3));
            DEFactory.StripByteCountsDE stripByteCountsDE = new DEFactory.StripByteCountsDE(n2);
            iFD.add(stripByteCountsDE);
            if (tIFFImageWriteParam == null) {
                iFD.add(new DEFactory.XResolutionDE(72.0));
                iFD.add(new DEFactory.YResolutionDE(72.0));
            } else {
                iFD.add(new DEFactory.XResolutionDE(tIFFImageWriteParam.getXResolution()));
                iFD.add(new DEFactory.YResolutionDE(tIFFImageWriteParam.getYResolution()));
            }
            iFD.add(new DEFactory.ResolutionUnitDE(2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = byteArrayOutputStream;
            JPEGOutputStream jPEGOutputStream = null;
            if (n == 7) {
                jPEGOutputStream = new JPEGOutputStream(byteArrayOutputStream);
                int n11 = tIFFImageWriteParam == null ? 50 : (int)(tIFFImageWriteParam.getCompressionQuality() * 100.0f);
                jPEGOutputStream.setZZQuantizationTable(0, JPEGConstants.LQT, n11);
                jPEGOutputStream.setZZQuantizationTable(1, JPEGConstants.CQT, n11);
                jPEGOutputStream.setRawDCHuffmanTable(0, JPEGConstants.HLDCTable);
                jPEGOutputStream.setRawACHuffmanTable(0, JPEGConstants.HLACTable);
                jPEGOutputStream.setRawDCHuffmanTable(1, JPEGConstants.HCDCTable);
                jPEGOutputStream.setRawACHuffmanTable(1, JPEGConstants.HCACTable);
                jPEGOutputStream.defineQuantizationTables();
                jPEGOutputStream.defineHuffmanTables();
                jPEGOutputStream.close();
                DEFactory.JPEGTablesDE jPEGTablesDE = new DEFactory.JPEGTablesDE(byteArrayOutputStream.toByteArray());
                iFD.add(jPEGTablesDE);
                byteArrayOutputStream.reset();
                outputStream = jPEGOutputStream;
            }
            double d = 0.299;
            double d2 = 0.587;
            double d3 = 0.114;
            DEFactory.YCbCrCoefficientsDE yCbCrCoefficientsDE = new DEFactory.YCbCrCoefficientsDE();
            yCbCrCoefficientsDE.setLumaRed(d);
            yCbCrCoefficientsDE.setLumaGreen(d2);
            yCbCrCoefficientsDE.setLumaBlue(d3);
            iFD.add(yCbCrCoefficientsDE);
            DEFactory.YCbCrSubSamplingDE yCbCrSubSamplingDE = new DEFactory.YCbCrSubSamplingDE();
            yCbCrSubSamplingDE.setHoriz(n7);
            yCbCrSubSamplingDE.setVert(n8);
            iFD.add(yCbCrSubSamplingDE);
            double d4 = 0.0;
            double d5 = 255.0;
            double d6 = 128.0;
            double d7 = 255.0;
            double d8 = 128.0;
            double d9 = 255.0;
            DEFactory.ReferenceBlackWhiteDE referenceBlackWhiteDE = new DEFactory.ReferenceBlackWhiteDE();
            referenceBlackWhiteDE.setY(d4, d5);
            referenceBlackWhiteDE.setCb(d6, d7);
            referenceBlackWhiteDE.setCr(d8, d9);
            iFD.add(referenceBlackWhiteDE);
            if (jPEGOutputStream == null) {
                tIFFYCbCrOutputStream = new TIFFYCbCrOutputStream(outputStream, n4, n8, n7);
                outputStream = new TIFFSubSamplingOutputStream(tIFFYCbCrOutputStream, n4, n8, n7);
            } else {
                tIFFYCbCrOutputStream = new TIFFYCbCrOutputStream(outputStream, n4, 1, 1);
                outputStream = tIFFYCbCrOutputStream;
            }
            tIFFYCbCrOutputStream.setPositioning(1);
            tIFFYCbCrOutputStream.setColourCoefficients(d, d2, d3);
            tIFFYCbCrOutputStream.setRfBWY(d4, d5);
            tIFFYCbCrOutputStream.setRfBWCb(d6, d7);
            tIFFYCbCrOutputStream.setRfBWCr(d8, d9);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            int n12 = 0;
            int n13 = 0;
            for (int i = 0; i < n5; i += n3) {
                Object[] objectArray;
                if (n5 - i < n3) {
                    n3 = n5 - i;
                }
                if (jPEGOutputStream != null) {
                    jPEGOutputStream.startOfImage();
                    objectArray = new int[]{n7 << 4 | n8, 17, 17};
                    int[] nArray2 = new int[]{0, 1, 1};
                    jPEGOutputStream.startOfFrame(n3, n9, (int[])objectArray, nArray2);
                    int[] nArray3 = new int[]{0, 1, 1};
                    jPEGOutputStream.startOfScan(nArray3);
                }
                for (int j = 0; j < n3; ++j) {
                    int n14;
                    for (n14 = 0; n14 < n4; ++n14) {
                        n12 = nArray[n14 + (i + j) * n4];
                        outputStream.write(n12 >> 16 & 0xFF);
                        outputStream.write(n12 >> 8 & 0xFF);
                        outputStream.write(n12 & 0xFF);
                    }
                    while (n14 < n9) {
                        outputStream.write(n12 >> 16 & 0xFF);
                        outputStream.write(n12 >> 8 & 0xFF);
                        outputStream.write(n12 & 0xFF);
                        ++n14;
                    }
                }
                outputStream.close();
                objectArray = byteArrayOutputStream.toByteArray();
                stripByteCountsDE.setCount(n13, objectArray.length);
                stripOffsetsDE.setOffset(n13, imageOutputStream.getStreamPosition());
                imageOutputStream.write((byte[])objectArray);
                byteArrayOutputStream.reset();
                ++n13;
            }
            return iFD;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(this.getClass().getName() + ".writeYCbCrImage:\n\t" + exception.getMessage());
        }
    }

    private BufferedImage convert(BufferedImage bufferedImage, int n) {
        if (bufferedImage.getType() == n) {
            return bufferedImage;
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, n);
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        ColorSpace colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, colorSpace2, null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

