/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.io.IntFilterInputStream;

public class TIFFSubSamplingInputStream
extends IntFilterInputStream {
    protected int width;
    protected int yf;
    protected int xf;
    protected int positioning;

    public TIFFSubSamplingInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream);
        this.width = n;
    }

    public TIFFSubSamplingInputStream(InputStream inputStream, int n, int n2, int n3, int n4) throws IOException {
        this(inputStream, n);
        this.setSubSampling(n2, n3);
        this.setPositioning(n4);
    }

    public void setSubSampling(int n, int n2) {
        this.yf = n;
        this.xf = n2;
    }

    public void setPositioning(int n) {
        this.positioning = n;
    }

    public int read() throws IOException {
        throw new IOException(this.getClass().getName() + ".read:\t\nInternal Error: Please use read(int[] buf,int off,int len).");
    }

    protected void readDataUnit(int[] nArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = n;
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                nArray[n6 + n4] = (this.in.read() & 0xFF) << 16;
            }
            while (n4 < this.xf) {
                this.in.read();
                ++n4;
            }
            n6 += this.width;
        }
        while (n5 < this.yf) {
            for (n4 = 0; n4 < this.xf; ++n4) {
                this.in.read();
            }
            ++n5;
        }
        n4 = (this.in.read() & 0xFF) << 8;
        int n7 = this.in.read() & 0xFF;
        n6 = n;
        for (n5 = 0; n5 < n2; ++n5) {
            for (int i = 0; i < n3; ++i) {
                int n8 = n6 + i;
                nArray[n8] = nArray[n8] | (n4 | n7);
            }
            n6 += this.width;
        }
    }

    public int read(int[] nArray, int n, int n2) throws IOException {
        int n3 = n2 / this.width;
        for (int i = 0; i < n3; i += this.yf) {
            for (int j = 0; j < this.width; j += this.xf) {
                this.readDataUnit(nArray, n + i * this.width + j, n3 - i >= this.yf ? this.yf : n3 & this.yf - 1, this.width - j >= this.xf ? this.xf : this.width & this.xf - 1);
            }
        }
        return n2;
    }
}

