/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.tiff;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFConstants;

public class TIFFYCbCrOutputStream
extends FilterOutputStream
implements TIFFConstants {
    protected int w;
    protected int yf;
    protected int xf;
    protected int positioning;
    protected double LumaRed;
    protected double LumaGreen;
    protected double LumaBlue;
    protected double RfBY;
    protected double RfBCb;
    protected double RfBCr;
    protected double RfWY;
    protected double RfWCb;
    protected double RfWCr;
    protected double RCr;
    protected double BCb;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    protected int col;
    protected int off;
    protected int max;
    protected boolean needToFlush;

    public TIFFYCbCrOutputStream(OutputStream outputStream, int n, int n2, int n3) {
        super(outputStream);
        this.w = n;
        this.yf = n2;
        this.xf = n3;
        this.col = 0;
        this.off = 0;
        this.max = n2 * n3;
        this.red = new byte[this.max];
        this.green = new byte[this.max];
        this.blue = new byte[this.max];
        this.needToFlush = false;
    }

    public void setPositioning(int n) {
        this.positioning = n;
    }

    public void setColourCoefficients(double d, double d2, double d3) {
        this.LumaRed = d;
        this.LumaGreen = d2;
        this.LumaBlue = d3;
        this.RCr = 1.0 / (2.0 - 2.0 * d);
        this.BCb = 1.0 / (2.0 - 2.0 * d3);
    }

    public void setRfBWY(double d, double d2) {
        this.RfBY = d;
        this.RfWY = d2;
    }

    public void setRfBWCb(double d, double d2) {
        this.RfBCb = d;
        this.RfWCb = d2;
    }

    public void setRfBWCr(double d, double d2) {
        this.RfBCr = d;
        this.RfWCr = d2;
    }

    protected void writeDataUnit() throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.max; ++i) {
            double d3 = (double)(this.red[i] & 0xFF) / 255.0;
            double d4 = (double)(this.green[i] & 0xFF) / 255.0;
            double d5 = (double)(this.blue[i] & 0xFF) / 255.0;
            double d6 = this.LumaRed * d3 + this.LumaGreen * d4 + this.LumaBlue * d5;
            double d7 = (d5 - d6) * this.BCb * 255.0;
            double d8 = (d3 - d6) * this.RCr * 255.0;
            d6 *= 255.0;
            d6 = d6 * (this.RfWY - this.RfBY) / 255.0 + this.RfBY;
            d7 = d7 * (this.RfWCb - this.RfBCb) / 127.0 + this.RfBCb;
            d8 = d8 * (this.RfWCr - this.RfBCr) / 127.0 + this.RfBCr;
            if (d6 > 255.0) {
                d6 = 255.0;
            }
            this.out.write((int)d6);
            d += d7 > 255.0 ? 255.0 : d7;
            d2 += d8 > 255.0 ? 255.0 : d8;
        }
        this.out.write((int)(d / (double)this.max));
        this.out.write((int)(d2 / (double)this.max));
        this.needToFlush = false;
    }

    public void write(int n) throws IOException {
        switch (this.col) {
            case 0: {
                this.red[this.off++] = (byte)n;
                break;
            }
            case 1: {
                this.green[this.off++] = (byte)n;
                break;
            }
            case 2: {
                this.blue[this.off++] = (byte)n;
            }
        }
        if (this.off == this.max) {
            this.off = 0;
            ++this.col;
        }
        if (this.col == 3) {
            this.col = 0;
            this.writeDataUnit();
        } else {
            this.needToFlush = true;
        }
    }

    public void write1(int n) throws IOException {
        double d = (double)(n >> 16 & 0xFF) / 255.0;
        double d2 = (double)(n >> 8 & 0xFF) / 255.0;
        double d3 = (double)(n & 0xFF) / 255.0;
        double d4 = this.LumaRed * d + this.LumaGreen * d2 + this.LumaBlue * d3;
        double d5 = (d3 - d4) / (2.0 - 2.0 * this.LumaBlue) * 255.0;
        double d6 = (d - d4) / (2.0 - 2.0 * this.LumaRed) * 255.0;
        d4 *= 255.0;
        d4 = d4 * (this.RfWY - this.RfBY) / 255.0 + this.RfBY;
        d5 = d5 * (this.RfWCb - this.RfBCb) / 127.0 + this.RfBCb;
        d6 = d6 * (this.RfWCr - this.RfBCr) / 127.0 + this.RfBCr;
        this.out.write((int)d4);
        this.out.write((int)d5);
        this.out.write((int)d6);
    }

    public void flush() throws IOException {
        if (this.needToFlush) {
            this.writeDataUnit();
        }
        this.col = 0;
        this.off = 0;
        super.flush();
    }
}

