/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.io.Base64Table;

public class Base64OutputStream
extends FilterOutputStream
implements Base64Table {
    static byte[] decodeTable;
    private int pos = 0;
    private byte[] b3 = new byte[3];
    private byte[] b4 = new byte[4];

    public Base64OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        if (n <= 32) {
            return;
        }
        this.b4[this.pos++] = (byte)n;
        if (this.pos == 4) {
            int n2 = this.decode(this.b3, this.b4);
            this.out.write(this.b3, 0, n2);
            this.pos = 0;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    private int decode(byte[] byArray, byte[] byArray2) throws IOException {
        int n = 0;
        if (byArray2[3] != 61) {
            n = decodeTable[byArray2[0] & 0x7F] << 18;
            n += decodeTable[byArray2[1] & 0x7F] << 12;
            n += decodeTable[byArray2[2] & 0x7F] << 6;
            byArray[0] = (byte)((n += decodeTable[byArray2[3] & 0x7F]) >> 16 & 0xFF);
            byArray[1] = (byte)(n >> 8 & 0xFF);
            byArray[2] = (byte)(n & 0xFF);
            return 3;
        }
        if (byArray2[2] != 61) {
            n = decodeTable[byArray2[0] & 0x7F] << 18;
            n += decodeTable[byArray2[1] & 0x7F] << 12;
            byArray[0] = (byte)((n += decodeTable[byArray2[2] & 0x7F] << 6) >> 16 & 0xFF);
            byArray[1] = (byte)(n >> 8 & 0xFF);
            return 2;
        }
        n = decodeTable[byArray2[0] & 0x7F] << 18;
        byArray[0] = (byte)((n += decodeTable[byArray2[1] & 0x7F] << 12) >> 16 & 0xFF);
        return 1;
    }

    public void flush() throws IOException {
        if (this.pos != 0) {
            System.err.println(this.getClass().getName() + "flush():\n\tBase64 input not properly padded. Stream length is not a multiple of 4");
        }
        super.flush();
    }

    public static void main(String[] stringArray) {
        try {
            String string = "PD94bWwgdmVyc2lvbj0iMS4wIj8+CjxjaGVja291dC1zaG9wcGlu";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
            base64OutputStream.write(string.getBytes());
            System.out.print(new String(byteArrayOutputStream.toByteArray()));
            base64OutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        int n;
        decodeTable = new byte[128];
        for (n = 0; n < decodeTable.length; ++n) {
            Base64OutputStream.decodeTable[n] = -1;
        }
        for (n = 0; n < 64; ++n) {
            Base64OutputStream.decodeTable[Base64OutputStream.encodeTable[n]] = (byte)n;
        }
    }
}

