/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.io.BitInputStream;

public class LZWInputStream
extends BitInputStream {
    private static final int MAXCODE = 4096;
    private int[] prefix = new int[4096];
    private int[] suffix = new int[4096];
    private int[] stack = new int[4096];
    private int sp = 0;
    private int dataSize = 0;
    private int clearCode = 0;
    private int eoiCode = 0;
    private int availCode = 0;
    private int lastCode = 4096;
    private int codeSize = 0;
    private int codeMask = 0;
    private int first = 0;

    public LZWInputStream(InputStream inputStream, int n, boolean bl) throws IOException {
        super(inputStream, bl);
        this.dataSize = n;
        this.sp = 0;
        this.first = 0;
        this.resetTables();
        for (int i = 0; i < this.clearCode; ++i) {
            this.prefix[i] = 4096;
            this.suffix[i] = i;
        }
    }

    private void resetTables() {
        this.clearCode = 1 << this.dataSize;
        this.eoiCode = this.clearCode + 1;
        this.availCode = this.clearCode + 2;
        this.lastCode = 4096;
        this.codeSize = this.dataSize + 1;
        this.codeMask = (1 << this.codeSize) - 1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 < 0) {
                return i;
            }
            byArray[n + i] = (byte)n3;
        }
        return n2;
    }

    public int read() throws IOException {
        int n;
        if (this.sp > 0) {
            return this.stack[--this.sp];
        }
        while ((n = this.readBits(this.codeSize)) >= 0) {
            if (n == this.eoiCode) {
                return -1;
            }
            this.decode(n);
            if (this.sp <= 0) continue;
            return this.stack[--this.sp];
        }
        throw new IOException(this.getClass().getName() + ".read:\n\tMissing eoi code !");
    }

    private void decode(int n) throws IOException {
        if (n == this.clearCode) {
            this.codeSize = this.dataSize + 1;
            this.codeMask = (1 << this.codeSize) - 1;
            this.availCode = this.clearCode + 2;
            this.lastCode = 4096;
            return;
        }
        if (n > this.availCode) {
            throw new IOException(this.getClass().getName() + "decode:\n\tIllegal LZW-Code [" + n + "] > [" + this.availCode + "]");
        }
        if (this.lastCode == 4096) {
            this.first = this.suffix[n];
            this.stack[this.sp++] = this.first;
            this.lastCode = n;
            return;
        }
        int n2 = n;
        if (n == this.availCode) {
            this.stack[this.sp++] = this.first;
            n = this.lastCode;
        }
        while (n > this.clearCode) {
            this.stack[this.sp++] = this.suffix[n];
            n = this.prefix[n];
        }
        this.first = this.suffix[n];
        this.stack[this.sp++] = this.first;
        this.prefix[this.availCode] = this.lastCode;
        this.suffix[this.availCode] = this.first;
        if (this.availCode < 4096) {
            ++this.availCode;
        }
        if (this.availCode == this.codeMask) {
            ++this.codeSize;
            this.codeMask = (1 << this.codeSize) - 1;
        }
        this.lastCode = n2;
    }
}

