/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.io.BitInputStream;
import uk.co.mmscomputing.io.ModHuffmanTable;

public class ModHuffmanInputStream
extends BitInputStream
implements ModHuffmanTable {
    protected int state = 0;

    public ModHuffmanInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void skipPadding(int n) throws IOException {
        super.skipPadding(n);
        this.state = 0;
    }

    public void syncWithEOL() throws IOException {
        if (this.state != 2) {
            this.needBits(12);
            while (this.availableBits() >= 12) {
                if (this.getBits(12) == 2048) {
                    this.clrBits(12);
                    break;
                }
                this.clrBits(1);
                this.needBits(12);
            }
        }
        this.state = 0;
    }

    public void readEOL() throws IOException {
        this.syncWithEOL();
    }

    public int getState() {
        return this.state;
    }

    public int getColour(int n) {
        return this.state == 1 ? ~n : n;
    }

    public int read() throws IOException {
        int n;
        if (this.state == 0) {
            this.state = 1;
            n = this.read(makeUpWhite, 12, termWhite, 8);
        } else {
            this.state = 0;
            n = this.read(makeUpBlack, 13, termBlack, 12);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        throw new IOException(this.getClass().getName() + ".read:\n\tInternal Error. Cannot read whole byte array with this stream !!!");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException(this.getClass().getName() + ".read:\n\tInternal Error. Cannot read whole byte array with this stream !!!");
    }

    private int read(int[][] nArray, int n, int[][] nArray2, int n2) throws IOException {
        this.needBits(n2);
        int n3 = this.findToken(nArray2);
        if (n3 >= 0) {
            return n3;
        }
        int n4 = 0;
        this.needBits(n);
        n3 = this.findToken(nArray);
        if (n3 == 0) {
            this.state = 2;
            return 0;
        }
        if (n3 >= 0) {
            while (n3 == 2560) {
                n4 += 2560;
                this.needBits(n);
                n3 = this.findToken(nArray);
            }
            if (n3 >= 0) {
                n4 += n3;
            }
            this.needBits(n2);
        }
        if ((n3 = this.findToken(nArray2)) >= 0) {
            return n4 + n3;
        }
        return this.checkEOL();
    }

    protected int findToken(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            int n = this.getBits(nArray2[2]);
            if (nArray2[0] != n) continue;
            this.clrBits(nArray2[2]);
            return nArray2[1];
        }
        return -1;
    }

    protected int checkEOL() throws IOException {
        this.needBits(12);
        while (this.availableBits() >= 12) {
            int n = this.getBits(12);
            if (n == 2048) {
                this.state = 2;
                this.clrBits(12);
                return 0;
            }
            if (n != 0) {
                throw new ModHuffmanCodingException(this.getClass().getName() + ".checkEOL:\n\tCoding error: End of line code is missing.");
            }
            this.clrBits(1);
            this.needBits(12);
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            byte[] byArray = new byte[]{-78, 89, 1};
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ModHuffmanInputStream modHuffmanInputStream = new ModHuffmanInputStream(byteArrayInputStream);
            while ((n = modHuffmanInputStream.read()) != -1) {
                System.out.println("runlen= " + n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class ModHuffmanCodingException
    extends IOException {
        public ModHuffmanCodingException(String string) {
            super(string);
        }
    }
}

