/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.io.BitOutputStream;
import uk.co.mmscomputing.io.ModHuffmanTable;

public class ModHuffmanOutputStream
extends BitOutputStream
implements ModHuffmanTable {
    protected int state = 0;

    public ModHuffmanOutputStream() {
    }

    public ModHuffmanOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() throws IOException {
        super.flush();
        this.state = 0;
    }

    public void reset() throws IOException {
        super.reset();
        this.state = 0;
    }

    public int getState() {
        return this.state;
    }

    public void writeEOL() throws IOException {
        super.flush();
        this.write(0, 4);
        this.write(2048, 12);
        this.state = 0;
    }

    public void write(int n) throws IOException {
        if (this.state == 0) {
            this.writeWhite(n);
            this.state = 1;
        } else {
            this.writeBlack(n);
            this.state = 0;
        }
    }

    private void writeWhite(int n) throws IOException {
        int[] nArray;
        while (n > 2623) {
            this.write(3968, 12);
            n -= 2560;
        }
        if (n > 63) {
            int n2 = n / 64 - 1;
            nArray = makeUpWhite[n2];
            this.write(nArray[0], nArray[2]);
        }
        nArray = termWhite[n & 0x3F];
        this.write(nArray[0], nArray[2]);
    }

    private void writeBlack(int n) throws IOException {
        int[] nArray;
        while (n > 2623) {
            this.write(3968, 12);
            n -= 2560;
        }
        if (n > 63) {
            int n2 = n / 64 - 1;
            nArray = makeUpBlack[n2];
            this.write(nArray[0], nArray[2]);
        }
        nArray = termBlack[n & 0x3F];
        this.write(nArray[0], nArray[2]);
    }

    public static void main(String[] stringArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ModHuffmanOutputStream modHuffmanOutputStream = new ModHuffmanOutputStream(byteArrayOutputStream);
            modHuffmanOutputStream.writeWhite(1728);
            modHuffmanOutputStream.flush();
            modHuffmanOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                System.out.println("[" + i + "]=" + Integer.toHexString(byArray[i] & 0xFF));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

