/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.io.ModHuffmanInputStream;
import uk.co.mmscomputing.io.ModREADTable;

public class ModModREADInputStream
extends ModHuffmanInputStream
implements ModREADTable {
    private int[] refline = null;
    private int[] codeline = null;
    private int clindex = 0;
    private int a0;
    private int b1;
    private int maxb1;
    private int code;
    private int width;

    public ModModREADInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream);
        this.width = n;
        this.refline = new int[n + 3];
        this.codeline = new int[n + 3];
        this.init(n);
    }

    protected void init(int n) throws IOException {
        this.clindex = 1;
        this.codeline[0] = n;
        this.getREADCode();
    }

    protected void initNewLine() throws IOException {
        if (this.code == 9) {
            this.readHorizontalMode2();
        }
        int[] nArray = this.refline;
        this.refline = this.codeline;
        this.codeline = nArray;
        this.maxb1 = this.clindex;
        this.refline[this.maxb1] = this.width;
        this.refline[this.maxb1 + 1] = this.width;
        this.refline[this.maxb1 + 2] = this.width;
        this.clindex = 0;
        this.b1 = 0;
        this.a0 = 0;
    }

    public void readEOL() throws IOException {
        this.initNewLine();
    }

    protected int getREADCode() throws IOException {
        this.needBits(24);
        this.code = this.findToken(codes);
        return this.code;
    }

    private void setB1() {
        if (this.a0 == 0) {
            this.b1 = 0;
        } else {
            while (0 < this.b1 && this.a0 < this.refline[this.b1 - 1]) {
                --this.b1;
            }
            while (this.b1 < this.maxb1 && this.refline[this.b1] <= this.a0) {
                ++this.b1;
            }
        }
        if ((this.b1 & 1) != (this.clindex & 1)) {
            ++this.b1;
        }
    }

    private int readPassMode() throws IOException {
        int n = 0;
        do {
            this.setB1();
            int n2 = this.refline[this.b1 + 1] - this.a0;
            this.a0 += n2;
            n += n2;
        } while (this.getREADCode() == 0);
        return n += this.read2D();
    }

    private int readHorizontalMode1() throws IOException {
        this.state = (this.clindex & 1) == 0 ? 0 : 1;
        int n = super.read();
        this.a0 += n;
        this.codeline[this.clindex++] = this.a0;
        this.code = 9;
        return n;
    }

    private int readHorizontalMode2() throws IOException {
        int n = super.read();
        this.a0 += n;
        this.codeline[this.clindex++] = this.a0;
        this.getREADCode();
        return n;
    }

    private int readVerticalMode() throws IOException {
        this.setB1();
        int n = this.code - 5;
        int n2 = this.refline[this.b1] + n;
        int n3 = n2 - this.a0;
        this.a0 = n2;
        this.codeline[this.clindex++] = this.a0;
        this.getREADCode();
        return n3;
    }

    protected int read2D() throws IOException {
        switch (this.code) {
            case 0: {
                return this.readPassMode();
            }
            case 1: {
                return this.readHorizontalMode1();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.readVerticalMode();
            }
            case 9: {
                return this.readHorizontalMode2();
            }
        }
        return -1;
    }

    protected int read1D() throws IOException {
        int n = super.read();
        this.a0 += n;
        this.codeline[this.clindex++] = this.a0;
        return n;
    }

    public int read() throws IOException {
        return this.read2D();
    }
}

