/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.IOException;
import java.io.OutputStream;
import uk.co.mmscomputing.io.ModHuffmanOutputStream;

public abstract class READOutputStream
extends ModHuffmanOutputStream {
    private boolean H2;
    private int clindex = 0;
    private int a0;
    private int b1;
    private int maxb1;
    private int width;
    private int[] refline = null;
    private int[] codeline = null;

    public READOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.init(n);
    }

    private void init(int n) {
        this.width = n;
        this.refline = new int[n + 3];
        this.codeline = new int[n + 3];
        this.H2 = false;
        this.clindex = 0;
        this.codeline[0] = n;
    }

    protected void cleanupEOL() throws IOException {
        if (this.H2) {
            this.writeH2(0);
        }
    }

    public void flush() throws IOException {
        this.cleanupEOL();
        super.flush();
    }

    public void writeEOL() throws IOException {
        int[] nArray = this.refline;
        this.refline = this.codeline;
        this.codeline = nArray;
        this.maxb1 = this.clindex;
        this.refline[this.maxb1] = this.width;
        this.refline[this.maxb1 + 1] = this.width;
        this.refline[this.maxb1 + 2] = this.width;
        this.clindex = 0;
        this.b1 = 0;
        this.a0 = 0;
        this.H2 = false;
    }

    private void writeH2(int n) throws IOException {
        this.H2 = false;
        this.write1D(n);
    }

    private void setB1() {
        if (this.a0 == 0) {
            this.b1 = 0;
        } else {
            while (0 < this.b1 && this.a0 < this.refline[this.b1 - 1]) {
                --this.b1;
            }
            while (this.b1 < this.maxb1 && this.refline[this.b1] <= this.a0) {
                ++this.b1;
            }
        }
        if ((this.b1 & 1) != (this.clindex & 1)) {
            ++this.b1;
        }
    }

    protected void write2D(int n) throws IOException {
        if (this.H2) {
            this.writeH2(n);
            return;
        }
        int n2 = this.a0 + n;
        this.setB1();
        while (this.refline[this.b1 + 1] < n2) {
            this.write(8, 4);
            this.a0 = this.refline[this.b1 + 1];
            this.setB1();
        }
        int n3 = n2 - this.refline[this.b1];
        if (Math.abs(n3) <= 3) {
            switch (n3) {
                case -3: {
                    this.write(32, 7);
                    break;
                }
                case -2: {
                    this.write(16, 6);
                    break;
                }
                case -1: {
                    this.write(2, 3);
                    break;
                }
                case 0: {
                    this.write(1, 1);
                    break;
                }
                case 1: {
                    this.write(6, 3);
                    break;
                }
                case 2: {
                    this.write(48, 6);
                    break;
                }
                case 3: {
                    this.write(96, 7);
                }
            }
            this.a0 = n2;
            this.codeline[this.clindex++] = this.a0;
        } else {
            this.write(4, 3);
            this.write1D(n2 - this.a0);
            this.H2 = true;
        }
    }

    protected void write1D(int n) throws IOException {
        this.state = (this.clindex & 1) == 0 ? 0 : 1;
        super.write(n);
        this.a0 += n;
        this.codeline[this.clindex++] = this.a0;
    }
}

