/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RLEBitInputStream
extends FilterInputStream {
    private int rlen;
    private int ccw;
    private boolean invert = false;

    public RLEBitInputStream(InputStream inputStream) {
        super(inputStream);
        this.resetToStartCodeWord();
    }

    public void resetToStartCodeWord() {
        this.ccw = 1;
        this.rlen = 0;
    }

    public void setInvert(boolean bl) {
        this.invert = bl;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                return i == 0 ? -1 : i;
            }
            byArray[n + i] = (byte)n3;
        }
        return n2;
    }

    public int readBits(int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = n; i >= n2; --i) {
            while (this.rlen == 0) {
                this.rlen = this.in.read();
                if (this.rlen == -1) {
                    return -1;
                }
                this.ccw = this.ccw + 1 & 1;
            }
            --this.rlen;
            if (this.ccw == 1) continue;
            n3 |= 1 << i;
        }
        return this.invert ? ~n3 & 0xFF : n3;
    }

    public int read() throws IOException {
        int n = 0;
        for (int i = 7; i >= 0; --i) {
            while (this.rlen == 0) {
                this.rlen = this.in.read();
                if (this.rlen == -1) {
                    return -1;
                }
                this.ccw = this.ccw + 1 & 1;
            }
            --this.rlen;
            if (this.ccw == 1) continue;
            n |= 1 << i;
        }
        return this.invert ? ~n & 0xFF : n;
    }
}

