/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiSystem;
import uk.co.mmscomputing.sms.SMSDLLEstablished;
import uk.co.mmscomputing.sms.SMSDLLReleased;
import uk.co.mmscomputing.sms.SMSDataUnit;
import uk.co.mmscomputing.sms.SMSLandLineChannel;
import uk.co.mmscomputing.sms.SMSReceiver;
import uk.co.mmscomputing.sms.SMSSubmit;
import uk.co.mmscomputing.sms.SMSSubmitAckReport;

public class SMSCapiSender
implements SMSReceiver,
Runnable {
    private static int mr = 1;
    private SMSLandLineChannel smschannel = null;
    private String centre;
    private String destination;
    private String text;

    public SMSCapiSender(String string, String string2, String string3) {
        this.destination = string2;
        this.centre = string;
        this.text = string3;
        System.out.println("3\bSEND MESSAGE TO: " + this.destination + " via " + this.centre + " :\n" + this.text);
    }

    public void send(SMSDataUnit sMSDataUnit) throws IOException {
        this.smschannel.send(sMSDataUnit);
    }

    public void received(SMSDataUnit sMSDataUnit) throws IOException {
        if (sMSDataUnit instanceof SMSDLLEstablished) {
            SMSSubmit sMSSubmit = new SMSSubmit(mr++, this.destination, this.text);
            this.smschannel.send(sMSSubmit);
        } else if (sMSDataUnit instanceof SMSSubmitAckReport) {
            this.smschannel.send(new SMSDLLReleased());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws IOException {
        CapiCallApplication capiCallApplication = CapiSystem.getSystem().getCaller();
        CapiChannel capiChannel = null;
        try {
            int n;
            capiChannel = capiCallApplication.connect(this.centre, 10000L);
            this.smschannel = new SMSLandLineChannel(capiChannel.getPCMOutputStream(), capiChannel.getPCMInputStream(), this);
            InputStream inputStream = this.smschannel.getInputStream();
            byte[] byArray = new byte[256];
            while ((n = inputStream.read(byArray)) != -1) {
                System.out.println(new String(byArray, 0, n));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("9\b" + this.getClass().getName() + ".send:\n\t" + iOException);
        }
        finally {
            if (this.smschannel != null) {
                this.smschannel.close();
            }
            if (capiChannel != null) {
                capiChannel.close();
            }
        }
    }

    public void run() {
        try {
            this.send();
        }
        catch (Exception exception) {
            System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
        }
    }
}

