/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSAddress;
import uk.co.mmscomputing.sms.SMSTransportProtocolDataUnit;

public class SMSCommand
extends SMSTransportProtocolDataUnit {
    public SMSCommand(int n, String string, int n2, int n3) {
        this(n, string, n2, n3, new byte[0]);
    }

    public SMSCommand(int n, String string, int n2, int n3, byte[] byArray) {
        this.put("TP-MTI", new Integer(2));
        this.put("TP-SRR", new Boolean(n2 == 0));
        this.put("TP-UDHI", new Boolean(false));
        this.put("TP-MR", new Integer(n));
        this.put("TP-PID", new Integer(0));
        this.put("TP-CT", new Integer(n2));
        this.put("TP-MN", new Integer(n3));
        this.put("TP-DA", new SMSAddress(string));
        this.setUserData(byArray);
    }

    public SMSCommand(InputStream inputStream) throws IOException {
        this.readFrom(inputStream);
    }

    public void readFrom(InputStream inputStream) throws IOException {
        int n = this.read(inputStream);
        this.put("TP-MTI", new Integer(n & 3));
        this.put("TP-SRR", new Boolean((n >> 5 & 1) == 0));
        this.put("TP-UDHI", new Boolean((n >> 6 & 1) != 0));
        this.put("TP-MR", new Integer(this.readInt(inputStream)));
        this.put("TP-PID", new Integer(this.readOctet(inputStream)));
        this.put("TP-CT", new Integer(this.readOctet(inputStream)));
        this.put("TP-MN", new Integer(this.readInt(inputStream)));
        this.put("TP-DA", new SMSAddress(inputStream));
        this.readUserDataFrom(inputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        int n = 2;
        if (this.getBoolean("TP-SRR")) {
            n |= 0x20;
        }
        outputStream.write(17);
        outputStream.write(n);
        outputStream.write(this.getInt("TP-MR"));
        outputStream.write(this.getOctet("TP-PID"));
        outputStream.write(this.getOctet("TP-CT"));
        outputStream.write(this.getInt("TP-MN"));
        ((SMSAddress)this.get("TP-DA")).writeTo(outputStream);
        this.writeUserDataTo(outputStream);
        outputStream.flush();
    }
}

