/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.sms.SMSDataUnit;

public class SMSDLLError
extends SMSDataUnit {
    private int errcode;

    public SMSDLLError() {
    }

    public SMSDLLError(int n) {
        this.errcode = n;
        this.put("DLL-Error", new Integer(this.errcode));
    }

    public int getErrorCode() {
        return this.errcode;
    }

    public void setErrorCode(int n) {
        this.errcode = n;
    }

    public void readFrom(InputStream inputStream) throws IOException {
        this.errcode = this.readOctet(inputStream);
        this.put("DLL-Error", new Integer(this.errcode));
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(18);
        outputStream.write(this.errcode);
        outputStream.flush();
    }

    public String toString() {
        String string = super.toString();
        switch (this.errcode) {
            case 1: {
                string = string + "Checksum is not correct.\n";
                break;
            }
            case 2: {
                string = string + "Message length not correct.\n";
                break;
            }
            case 3: {
                string = string + "Unknown type.\n";
                break;
            }
            case 4: {
                string = string + "Extension mechanism not supported.\n";
                break;
            }
            case 255: {
                string = string + "Unspecified error cause.\n";
                break;
            }
            default: {
                string = string + "Unknown error code.\n";
            }
        }
        return string;
    }
}

