/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.sms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import uk.co.mmscomputing.sms.SMSCommand;
import uk.co.mmscomputing.sms.SMSConstants;
import uk.co.mmscomputing.sms.SMSDLLError;
import uk.co.mmscomputing.sms.SMSDLLEstablished;
import uk.co.mmscomputing.sms.SMSDLLReleased;
import uk.co.mmscomputing.sms.SMSDataUnit;
import uk.co.mmscomputing.sms.SMSDeliver;
import uk.co.mmscomputing.sms.SMSDeliverAckReport;
import uk.co.mmscomputing.sms.SMSDeliverErrReport;
import uk.co.mmscomputing.sms.SMSException;
import uk.co.mmscomputing.sms.SMSStatusReport;
import uk.co.mmscomputing.sms.SMSSubmit;
import uk.co.mmscomputing.sms.SMSSubmitAckReport;
import uk.co.mmscomputing.sms.SMSSubmitErrReport;

public class SMSDataUnitFactory
implements SMSConstants {
    public static SMSDataUnit decode(boolean bl, byte[] byArray) throws IOException {
        int n = byArray[0] & 0x7F;
        switch (n) {
            case 18: {
                return new SMSDLLError(byArray[1] & 0xFF);
            }
            case 19: {
                return new SMSDLLEstablished();
            }
            case 20: {
                return new SMSDLLReleased();
            }
        }
        int n2 = byArray[1] & 0xFF;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 1, byArray.length - 1);
        if (bl) {
            switch (n) {
                case 17: {
                    switch (n2 & 3) {
                        case 0: {
                            return new SMSDeliver(byteArrayInputStream);
                        }
                        case 2: {
                            return new SMSStatusReport(byteArrayInputStream);
                        }
                        case 3: {
                            return new SMSDeliver(byteArrayInputStream);
                        }
                    }
                    break;
                }
                case 21: {
                    switch (n2 & 3) {
                        case 1: {
                            return new SMSSubmitAckReport(byteArrayInputStream);
                        }
                    }
                }
                case 22: {
                    switch (n2 & 3) {
                        case 1: {
                            return new SMSSubmitErrReport(byteArrayInputStream);
                        }
                    }
                }
            }
        } else {
            switch (n) {
                case 17: {
                    switch (n2 & 3) {
                        case 1: {
                            return new SMSSubmit(byteArrayInputStream);
                        }
                        case 2: {
                            return new SMSCommand(byteArrayInputStream);
                        }
                    }
                    break;
                }
                case 21: {
                    switch (n2 & 3) {
                        case 0: {
                            return new SMSDeliverAckReport(byteArrayInputStream);
                        }
                    }
                }
                case 22: {
                    switch (n2 & 3) {
                        case 0: {
                            return new SMSDeliverErrReport(byteArrayInputStream);
                        }
                    }
                }
            }
        }
        throw new SMSException.Type();
    }
}

